/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.database.mybatis.plugin.search.resolver;

import com.github.fartherp.framework.database.mybatis.plugin.search.enums.SearchOperator;
import com.github.fartherp.framework.database.mybatis.plugin.search.filter.CustomCondition;
import com.github.fartherp.framework.database.mybatis.plugin.search.filter.SearchFilter;
import com.github.fartherp.framework.database.mybatis.plugin.search.resolver.AbstractSqlResolverInter;
import com.github.fartherp.framework.database.mybatis.plugin.search.vo.Param;
import com.github.fartherp.framework.database.mybatis.plugin.search.vo.Searchable;
import java.util.List;
import org.springframework.util.StringUtils;

public class DefaultSqlResolver
extends AbstractSqlResolverInter {
    private ResolveSelf resolveSelf = new ResolveSelf();
    private ResolveWithAndFilters resolveWithAndFilters = new ResolveWithAndFilters();
    private ResolveWithOrFilters resolveWithOrFilters = new ResolveWithOrFilters();

    public DefaultSqlResolver(String alias) {
        super(alias);
    }

    @Override
    public void prepareSQL(StringBuilder ql, Searchable search) {
        if (!search.hasSearchFilter()) {
            return;
        }
        for (SearchFilter searchFilter : search.getSearchFilters()) {
            boolean needAppendBracket;
            CustomCondition customCondition = (CustomCondition)searchFilter;
            if (customCondition.getOperator() == SearchOperator.custom) continue;
            ql.append(" and ");
            boolean bl = needAppendBracket = customCondition.hasAndFilters() || customCondition.hasOrFilters();
            if (needAppendBracket) {
                ql.append("(");
            }
            this.resolveSelf.genCondition(ql, searchFilter);
            if (customCondition.hasAndFilters()) {
                this.resolveWithAndFilters.genCondition(ql, searchFilter);
            }
            if (customCondition.hasOrFilters()) {
                this.resolveWithOrFilters.genCondition(ql, searchFilter);
            }
            if (!needAppendBracket) continue;
            ql.append(")");
        }
    }

    @Override
    public void setValues(StringBuilder query, Searchable search) {
        int paramIndex = 1;
        for (SearchFilter searchFilter : search.getSearchFilters()) {
            paramIndex = this.resolveSelf.setValues(query, searchFilter, paramIndex);
            if (((CustomCondition)searchFilter).hasAndFilters()) {
                paramIndex = this.resolveWithAndFilters.setValues(query, searchFilter, paramIndex);
            }
            if (!((CustomCondition)searchFilter).hasOrFilters()) continue;
            paramIndex = this.resolveWithOrFilters.setValues(query, searchFilter, paramIndex);
        }
    }

    public class ResolveWithOrFilters {
        ResolveSelf resolveSelf;

        public ResolveWithOrFilters() {
            this.resolveSelf = new ResolveSelf();
        }

        public int setValues(StringBuilder query, List<SearchFilter> searchFilters, int paramIndex) {
            for (SearchFilter orSearchFilter : searchFilters) {
                paramIndex = this.resolveSelf.setValues(query, orSearchFilter, paramIndex);
            }
            return paramIndex;
        }

        public int setValues(StringBuilder query, SearchFilter searchFilter, int paramIndex) {
            for (SearchFilter searchFilter2 : ((CustomCondition)searchFilter).getOrFilters()) {
                paramIndex = this.setValues(query, searchFilter2, paramIndex);
            }
            return paramIndex;
        }

        public void genCondition(StringBuilder ql, SearchFilter searchFilter) {
            boolean isFirst = true;
            for (SearchFilter searchFilter2 : ((CustomCondition)searchFilter).getOrFilters()) {
                if (!isFirst) {
                    ql.append(" or ");
                }
                this.resolveSelf.genCondition(ql, searchFilter2);
                isFirst = false;
            }
        }
    }

    public class ResolveWithAndFilters {
        ResolveSelf resolveSelf;

        public ResolveWithAndFilters() {
            this.resolveSelf = new ResolveSelf();
        }

        public int setValues(StringBuilder query, List<SearchFilter> searchFilters, int paramIndex) {
            for (SearchFilter andSearchFilter : searchFilters) {
                paramIndex = this.setValues(query, andSearchFilter, paramIndex);
            }
            return paramIndex;
        }

        public int setValues(StringBuilder query, SearchFilter searchFilter, int paramIndex) {
            for (SearchFilter searchFilter2 : ((CustomCondition)searchFilter).getAndFilters()) {
                paramIndex = this.resolveSelf.setValues(query, searchFilter2, paramIndex);
            }
            return paramIndex;
        }

        public void genCondition(StringBuilder ql, SearchFilter searchFilter) {
            boolean isFirst = true;
            for (SearchFilter searchFilter2 : ((CustomCondition)searchFilter).getAndFilters()) {
                if (!isFirst) {
                    ql.append(" and ");
                }
                this.resolveSelf.genCondition(ql, searchFilter2);
                isFirst = false;
            }
        }
    }

    public class ResolveSelf {
        public int setValues(StringBuilder query, SearchFilter searchFilter, int paramIndex) {
            CustomCondition customCondition = (CustomCondition)searchFilter;
            if (customCondition.getOperator() == SearchOperator.custom) {
                return paramIndex;
            }
            if (customCondition.isUnaryFilter()) {
                return paramIndex;
            }
            Param cfr_ignored_0 = DefaultSqlResolver.this.param;
            query.toString().replaceAll("param_" + paramIndex++, DefaultSqlResolver.this.param.formtValue(customCondition, customCondition.getValue()).toString());
            return paramIndex;
        }

        public void genCondition(StringBuilder ql, SearchFilter searchFilter) {
            CustomCondition customCondition = (CustomCondition)searchFilter;
            String entityProperty = customCondition.getEntityProperty();
            String operatorStr = customCondition.getOperatorStr();
            Object entityValue = customCondition.getValue();
            ql.append(DefaultSqlResolver.this.param.aliasWithDot);
            ql.append(entityProperty);
            ql.append(" ");
            if (!customCondition.isUnaryFilter()) {
                ql.append(operatorStr);
                if ("in".equalsIgnoreCase(operatorStr)) {
                    String tep = StringUtils.arrayToDelimitedString((Object[])((String[])entityValue), (String)",");
                    ql.append("(");
                    ql.append(tep);
                    ql.append(")");
                } else {
                    ql.append("\"");
                    ql.append(entityValue);
                    ql.append("\"");
                }
            }
        }
    }
}

