/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.database.service.impl;

import com.github.fartherp.framework.database.dao.DaoMapper;
import com.github.fartherp.framework.database.dao.FieldAccessVo;
import com.github.fartherp.framework.database.service.GenericService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public abstract class GenericSqlMapServiceImpl<T extends FieldAccessVo, ID extends Serializable>
implements GenericService<T, ID> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public abstract DaoMapper<T, ID> getDao();

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(ID id) {
        Assert.notNull(id, (String)"delete failed due to PrimaryKey is null");
        this.getDao().deleteByPrimaryKey(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(ID[] ids) {
        this.getDao().deleteBatch((Serializable[])ids);
    }

    @Override
    public List<T> findAll() {
        return this.getDao().selectAll();
    }

    @Override
    public T findById(ID id) {
        return (T)((FieldAccessVo)this.getDao().selectByPrimaryKey(id));
    }

    @Override
    public long count() {
        return this.getDao().count();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ID saveEntity(T entity) {
        Assert.notNull(entity, (String)"save entity failed due to entity is null");
        this.getDao().insert(entity);
        return (ID)((Serializable)((FieldAccessVo)entity).primaryKey());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ID saveEntitySelective(T entity) {
        Assert.notNull(entity, (String)"save entity failed due to entity is null");
        this.getDao().insertSelective(entity);
        return (ID)((Serializable)((FieldAccessVo)entity).primaryKey());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveBatch(List<T> entitys) {
        Assert.notNull(entitys, (String)"saveBatch entitys failed due to entitys is null");
        if (CollectionUtils.isNotEmpty(entitys)) {
            this.getDao().insertBatch(entitys);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateEntity(T entity) {
        Assert.notNull(entity, (String)"update entity failed due to entity is null");
        this.getDao().updateByPrimaryKey(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateEntitySelective(T entity) {
        Assert.notNull(entity, (String)"update entity failed due to entity is null");
        this.getDao().updateByPrimaryKeySelective(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public T saveOrUpdate(T entity) {
        Assert.notNull(entity, (String)"save or update entity failed due to entity is null");
        Serializable id = (Serializable)((FieldAccessVo)entity).primaryKey();
        if (id == null) {
            this.saveEntity(entity);
        } else if (this.findById((ID)id) != null) {
            this.updateEntity(entity);
        } else {
            this.saveEntity(entity);
        }
        return entity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public T saveOrUpdateSelective(T entity) {
        Assert.notNull(entity, (String)"save or update entity failed due to entity is null");
        Serializable id = (Serializable)((FieldAccessVo)entity).primaryKey();
        if (id == null) {
            this.saveEntitySelective(entity);
        } else if (this.findById((ID)id) != null) {
            this.updateEntitySelective(entity);
        } else {
            this.saveEntitySelective(entity);
        }
        return entity;
    }
}

