/**************************************************************************
/* This class implements a BashScriptGenerator.
/*
/* Copyright (c) 2009 by Bernhard Bablok (mail@bablokb.de)
/*
/* This program is free software; you can redistribute it and/or modify
/* it under the terms of the GNU Library General Public License as published
/* by  the Free Software Foundation; either version 2 of the License or
/* (at your option) any later version.
/*
/* This program is distributed in the hope that it will be useful, but
/* WITHOUT ANY WARRANTY; without even the implied warranty of
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/* GNU Library General Public License for more details.
/*
/* You should have received a copy of the GNU Library General Public License
/* along with this program; see the file COPYING.LIB.  If not, write to
/* the Free Software Foundation Inc., 59 Temple Place - Suite 330,
/* Boston, MA  02111-1307 USA
/**************************************************************************/

package com.github.geko444.im4java.script;

import java.util.*;
import java.io.*;

import com.github.geko444.im4java.core.Operation;

/**
   This class implements a BashScriptGenerator.

   @version $Revision: 1.7 $
   @author  $Author: bablokb $
 
   @since 1.0.0
 */

public class BashScriptGenerator extends AbstractScriptGenerator {

  //////////////////////////////////////////////////////////////////////////////

  /**
     The default constructor.
  */

  public BashScriptGenerator() {
    ESC_EOL = '\\';
    ESC_SPECIAL = '\\';
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Write the header of the script.
  */

  protected void writeHeader() {
    getWriter().println(
       "#!/bin/bash\n"+
       "#-------------------------------------------------------\n"+
       "# Bash-script autogenerated by im4java\n"+
       "# at " + Calendar.getInstance().getTime() + "\n"+
       "#-------------------------------------------------------\n"
    );

    // add search-path
    String path=getSearchPath();
    if (path != null) {
      getWriter().println(
       "export PATH="+path+File.pathSeparator+"$PATH\n"
      );
    }
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Return the token as a script-argument. Normally, the argument token is
     only part of the script-argument if it contains a [wxh+x+y]-read-spec.
  */

  protected String getScriptArg(String pToken) {
    iArgIndex++;
    if (pToken.length()> Operation.IMG_PLACEHOLDER.length()) {
      return "\"${"+iArgIndex+"}\"" + 
	                  pToken.substring(Operation.IMG_PLACEHOLDER.length());
    } else {
      return "\"${"+iArgIndex+"}\"";
    }
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Quote the given string.

     <p>
     Note that this implementation is not 100% correct, since it does not
     handle the case with pre-escaped strings correctly.
     </p>
  */

  protected String quote(String pString) {
    if (pString.indexOf('"')==-1) {
      return '"'+pString+'"';
    } else {
      return '"'+pString.replace("\"",ESC_SPECIAL+"\"")+'"';
    }
  }
}