/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.core;

import com.github.geko444.im4java.core.CommandException;
import com.github.geko444.im4java.core.DynamicOperation;
import com.github.geko444.im4java.core.IM4JavaException;
import com.github.geko444.im4java.core.Operation;
import com.github.geko444.im4java.process.ErrorConsumer;
import com.github.geko444.im4java.process.ProcessStarter;
import com.github.geko444.im4java.process.ProcessTask;
import com.github.geko444.im4java.process.StandardStream;
import com.github.geko444.im4java.script.BashScriptGenerator;
import com.github.geko444.im4java.script.CmdScriptGenerator;
import com.github.geko444.im4java.script.ScriptGenerator;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;

public class ImageCommand
extends ProcessStarter
implements ErrorConsumer {
    private LinkedList<String> iCommands = new LinkedList();
    private ArrayList<String> iErrorText;
    private LinkedList<String> iTmpFiles = new LinkedList();
    private static ScriptGenerator iDefaultScriptGenerator = System.getProperty("os.name").startsWith("Windows") ? new CmdScriptGenerator() : new BashScriptGenerator();
    private ScriptGenerator iScriptGenerator = null;

    public ImageCommand() {
        this.setOutputConsumer(StandardStream.STDOUT);
        this.setErrorConsumer(this);
    }

    public ImageCommand(String ... pCommands) {
        this();
        this.setCommand(pCommands);
    }

    public void setCommand(String ... pCommands) {
        for (String cmd : pCommands) {
            this.iCommands.add(cmd);
        }
    }

    public LinkedList<String> getCommand() {
        return this.iCommands;
    }

    public ArrayList<String> getErrorText() {
        return this.iErrorText;
    }

    private LinkedList<String> prepareArguments(Operation pOperation, Object ... images) throws IOException, IM4JavaException {
        LinkedList<String> args = new LinkedList<String>(pOperation.getCmdArgs());
        args.addAll(0, this.iCommands);
        this.resolveImages(args, images);
        this.resolveDynamicOperations(pOperation, args, images);
        return args;
    }

    public void run(Operation pOperation, Object ... images) throws IOException, InterruptedException, IM4JavaException {
        LinkedList<String> args = this.prepareArguments(pOperation, images);
        try {
            this.run(args);
        }
        catch (Exception e) {
            this.removeTmpFiles();
            CommandException ce = new CommandException(e);
            ce.fillInStackTrace();
            throw ce;
        }
    }

    public ProcessTask getProcessTask(Operation pOperation, Object ... images) throws IOException, IM4JavaException {
        LinkedList<String> args = this.prepareArguments(pOperation, images);
        return this.getProcessTask(args);
    }

    @Override
    protected void finished(int pReturnCode) throws Exception {
        if (pReturnCode > 0) {
            CommandException ce = this.iErrorText.size() > 0 ? new CommandException(this.iErrorText.get(0)) : new CommandException("return code: " + pReturnCode);
            ce.setErrorText(this.iErrorText);
            ce.setReturnCode(pReturnCode);
            throw ce;
        }
        this.removeTmpFiles();
    }

    private void resolveImages(LinkedList<String> pArgs, Object ... pImages) throws IOException {
        ListIterator<String> argIterator = pArgs.listIterator();
        int i = 0;
        boolean havePlaceholder = false;
        String currentArg = null;
        for (Object obj : pImages) {
            havePlaceholder = false;
            while (argIterator.hasNext()) {
                currentArg = (String)argIterator.next();
                if (!currentArg.startsWith("?img?")) continue;
                havePlaceholder = true;
                break;
            }
            if (!havePlaceholder) {
                throw new IllegalArgumentException("more argument images than placeholders!");
            }
            if (obj instanceof String) {
                if (currentArg.length() == "?img?".length()) {
                    argIterator.set((String)obj);
                } else {
                    String modifier = currentArg.substring("?img?".length());
                    argIterator.set((String)obj + modifier);
                }
            } else if (obj instanceof BufferedImage) {
                String tmpFile = this.convert2TmpFile((BufferedImage)obj);
                argIterator.set(tmpFile);
                this.iTmpFiles.add(tmpFile);
            } else {
                throw new IllegalArgumentException(obj.getClass().getName() + " is an unsupported image-type");
            }
            ++i;
        }
    }

    private void resolveDynamicOperations(Operation pOp, LinkedList<String> pArgs, Object ... pImages) throws IM4JavaException {
        ListIterator<String> argIterator = pArgs.listIterator();
        ListIterator dynOps = pOp.getDynamicOperations().listIterator();
        while (dynOps.hasNext()) {
            DynamicOperation dynOp = (DynamicOperation)dynOps.next();
            Operation op = dynOp.resolveOperation(pImages);
            while (argIterator.hasNext() && !((String)argIterator.next()).equals("?dop?")) {
            }
            if (op == null) {
                argIterator.remove();
                continue;
            }
            LinkedList<String> args = dynOp.resolveOperation(pImages).getCmdArgs();
            if (args == null) {
                argIterator.remove();
                continue;
            }
            argIterator.remove();
            for (String arg : args) {
                argIterator.add(arg);
            }
        }
    }

    @Override
    public void consumeError(InputStream pInputStream) throws IOException {
        String line;
        InputStreamReader esr = new InputStreamReader(pInputStream);
        BufferedReader reader = new BufferedReader(esr);
        this.iErrorText = new ArrayList();
        while ((line = reader.readLine()) != null) {
            this.iErrorText.add(line);
        }
        reader.close();
        esr.close();
    }

    private String getTmpFile() throws IOException {
        File tmpFile = File.createTempFile("im4java-", ".png");
        tmpFile.deleteOnExit();
        return tmpFile.getAbsolutePath();
    }

    private String convert2TmpFile(BufferedImage pBufferedImage) throws IOException {
        String tmpFile = this.getTmpFile();
        ImageTypeSpecifier spec = ImageTypeSpecifier.createFromRenderedImage(pBufferedImage);
        Iterator<ImageWriter> iter = ImageIO.getImageWriters(spec, "TIFF");
        if (!iter.hasNext()) {
            iter = ImageIO.getImageWriters(spec, "PNG");
        }
        if (iter.hasNext()) {
            ImageWriter writer = iter.next();
            FileImageOutputStream fios = new FileImageOutputStream(new File(tmpFile));
            writer.setOutput(fios);
            writer.write(pBufferedImage);
            fios.close();
            writer.dispose();
        }
        return tmpFile;
    }

    private void removeTmpFiles() {
        for (String file : this.iTmpFiles) {
            try {
                new File(file).delete();
            }
            catch (Exception exception) {}
        }
    }

    public static void setDefaultScriptGenerator(ScriptGenerator pGen) {
        iDefaultScriptGenerator = pGen;
    }

    public void setScriptGenerator(ScriptGenerator pGen) {
        this.iScriptGenerator = pGen;
    }

    public void createScript(PrintWriter pWriter, Operation pOp, Properties pProps) {
        String localPath;
        ScriptGenerator sg = this.iScriptGenerator;
        if (sg == null) {
            sg = iDefaultScriptGenerator;
        }
        StringBuilder builder = new StringBuilder();
        for (String token : this.getCommand()) {
            builder.append(token).append(' ');
        }
        pProps.setProperty("im4java.cmd", builder.toString());
        String globalPath = ImageCommand.getGlobalSearchPath();
        if (globalPath == null) {
            globalPath = "";
        }
        if ((localPath = this.getSearchPath()) == null) {
            localPath = "";
        }
        pProps.setProperty("im4java.globalSearchPath", globalPath);
        pProps.setProperty("im4java.localSearchPath", localPath);
        sg.init(pWriter, pOp, pProps);
        sg.createScript();
    }

    public void createScript(String pFilename, Operation pOp, Properties pProps) throws FileNotFoundException {
        if (System.getProperty("os.name").startsWith("Windows")) {
            pFilename = pFilename + ".cmd";
        }
        PrintWriter pw = new PrintWriter(pFilename);
        this.createScript(pw, pOp, pProps);
        pw.close();
    }

    public void createScript(String pFilename, Operation pOp) throws FileNotFoundException {
        this.createScript(pFilename, pOp, new Properties());
    }
}

