/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.process;

import com.github.geko444.im4java.process.ErrorConsumer;
import com.github.geko444.im4java.process.InputProvider;
import com.github.geko444.im4java.process.OutputConsumer;
import com.github.geko444.im4java.process.ProcessEvent;
import com.github.geko444.im4java.process.ProcessEventListener;
import com.github.geko444.im4java.process.ProcessListener;
import com.github.geko444.im4java.process.ProcessTask;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;

public class ProcessStarter {
    public static final int BUFFER_SIZE = 65536;
    private static String iGlobalSearchPath = null;
    private String iSearchPath = null;
    private static AtomicInteger iPIDCounter = new AtomicInteger(0);
    private int iPID;
    private InputProvider iInputProvider = null;
    private OutputConsumer iOutputConsumer = null;
    private ErrorConsumer iErrorConsumer = null;
    private boolean iAsyncMode = false;
    private LinkedList<ProcessListener> iProcessListener = new LinkedList();
    private LinkedList<ProcessEventListener> iProcessEventListener = new LinkedList();

    protected ProcessStarter() {
        this.iPID = iPIDCounter.getAndAdd(1);
    }

    public void setInputProvider(InputProvider pInputProvider) {
        this.iInputProvider = pInputProvider;
    }

    public void setOutputConsumer(OutputConsumer pOutputConsumer) {
        this.iOutputConsumer = pOutputConsumer;
    }

    public void setErrorConsumer(ErrorConsumer pErrorConsumer) {
        this.iErrorConsumer = pErrorConsumer;
    }

    public void addProcessEventListener(ProcessEventListener pListener) {
        this.iProcessEventListener.add(pListener);
    }

    public void removeProcessEventListener(ProcessEventListener pListener) {
        this.iProcessEventListener.remove(pListener);
    }

    public void addProcessListener(ProcessListener pProcessListener) {
        this.iProcessListener.add(pProcessListener);
    }

    private void processInput(OutputStream pOutputStream) throws IOException {
        final BufferedOutputStream bos = new BufferedOutputStream(pOutputStream, 65536);
        new Thread(){

            @Override
            public void run() {
                try {
                    ProcessStarter.this.iInputProvider.provideInput(bos);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.run();
        bos.close();
        if (pOutputStream != null) {
            pOutputStream.close();
        }
    }

    private void processOutput(InputStream pInputStream, OutputConsumer pConsumer) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(pInputStream, 65536);
        pConsumer.consumeOutput(bis);
        bis.close();
        if (pInputStream != null) {
            pInputStream.close();
        }
    }

    private void processError(InputStream pInputStream, ErrorConsumer pConsumer) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(pInputStream, 65536);
        pConsumer.consumeError(bis);
        bis.close();
        if (pInputStream != null) {
            pInputStream.close();
        }
    }

    protected int run(LinkedList<String> pArgs) throws IOException, InterruptedException, Exception {
        if (!this.iAsyncMode) {
            Process pr = this.startProcess(pArgs);
            int rc = this.waitForProcess(pr);
            this.finished(rc);
            return rc;
        }
        ProcessTask pt = this.getProcessTask(pArgs);
        new Thread(pt).start();
        return 0;
    }

    protected ProcessTask getProcessTask(LinkedList<String> pArgs) {
        ProcessEvent pe = new ProcessEvent(this.iPID, this);
        pe.setReturnCode(-1);
        for (ProcessEventListener pel : this.iProcessEventListener) {
            pel.processInitiated(pe);
        }
        return new ProcessTask(this, pArgs, pe);
    }

    void runAndNotify(LinkedList<String> pArgs, ProcessEvent pProcessEvent) {
        try {
            Process pr = this.startProcess(pArgs);
            pProcessEvent.setProcess(pr);
            for (ProcessEventListener pel : this.iProcessEventListener) {
                pel.processStarted(pProcessEvent);
            }
            for (ProcessListener pl : this.iProcessListener) {
                pl.processStarted(pr);
            }
            int rc = this.waitForProcess(pr);
            pProcessEvent.setReturnCode(rc);
            this.finished(rc);
        }
        catch (Exception e) {
            pProcessEvent.setException(e);
            try {
                this.finished(e);
            }
            catch (Exception e2) {
                pProcessEvent.setException(e2);
            }
        }
        for (ProcessEventListener pel : this.iProcessEventListener) {
            pel.processTerminated(pProcessEvent);
        }
        for (ProcessListener pl : this.iProcessListener) {
            pl.processTerminated(pProcessEvent);
        }
    }

    private Process startProcess(LinkedList<String> pArgs) throws IOException, InterruptedException {
        String cmd;
        if (this.iSearchPath != null) {
            cmd = pArgs.getFirst();
            cmd = this.searchForCmd(cmd, this.iSearchPath);
            pArgs.set(0, cmd);
        } else if (iGlobalSearchPath != null) {
            cmd = pArgs.getFirst();
            cmd = this.searchForCmd(cmd, iGlobalSearchPath);
            pArgs.set(0, cmd);
        }
        ProcessBuilder builder = new ProcessBuilder(pArgs);
        return builder.start();
    }

    private int waitForProcess(final Process pProcess) throws IOException, InterruptedException {
        FutureTask<Object> outTask = null;
        FutureTask<Object> errTask = null;
        if (this.iInputProvider != null) {
            this.processInput(pProcess.getOutputStream());
        }
        if (this.iOutputConsumer != null) {
            outTask = new FutureTask<Object>(new Callable<Object>(){

                @Override
                public Object call() throws IOException {
                    ProcessStarter.this.processOutput(pProcess.getInputStream(), ProcessStarter.this.iOutputConsumer);
                    return null;
                }
            });
            new Thread(outTask).start();
        }
        if (this.iErrorConsumer != null) {
            errTask = new FutureTask<Object>(new Callable<Object>(){

                @Override
                public Object call() throws IOException {
                    ProcessStarter.this.processError(pProcess.getErrorStream(), ProcessStarter.this.iErrorConsumer);
                    return null;
                }
            });
            new Thread(errTask).start();
        }
        try {
            if (outTask != null) {
                outTask.get();
            }
            if (errTask != null) {
                errTask.get();
            }
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new IllegalStateException(e);
        }
        pProcess.waitFor();
        int rc = pProcess.exitValue();
        try {
            pProcess.getInputStream().close();
            pProcess.getOutputStream().close();
            pProcess.getErrorStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rc;
    }

    public void setAsyncMode(boolean pAsyncMode) {
        this.iAsyncMode = pAsyncMode;
    }

    public boolean isAsyncMode() {
        return this.iAsyncMode;
    }

    public static void setGlobalSearchPath(String pGlobalSearchPath) {
        iGlobalSearchPath = pGlobalSearchPath;
    }

    public static String getGlobalSearchPath() {
        return iGlobalSearchPath;
    }

    public void setSearchPath(String pSearchPath) {
        this.iSearchPath = pSearchPath;
    }

    public String getSearchPath() {
        return this.iSearchPath;
    }

    public static void setPIDCounter(int pPID) {
        iPIDCounter.set(pPID);
    }

    public void setPID(int pPID) {
        this.iPID = pPID;
    }

    public int getPID() {
        return this.iPID;
    }

    protected void finished(int pReturnCode) throws Exception {
    }

    protected void finished(Exception pException) throws Exception {
    }

    public String searchForCmd(String pCmd, String pPath) throws IOException, FileNotFoundException {
        if (new File(pCmd).isAbsolute()) {
            return pCmd;
        }
        boolean isWindows = File.pathSeparator.equals(";");
        String[] dirs = pPath.split(File.pathSeparator);
        for (int i = 0; i < dirs.length; ++i) {
            File cmd;
            if (isWindows) {
                cmd = new File(dirs[i], pCmd + ".exe");
                if (cmd.exists()) {
                    return cmd.getCanonicalPath();
                }
                cmd = new File(dirs[i], pCmd + ".cmd");
                if (cmd.exists()) {
                    return cmd.getCanonicalPath();
                }
                cmd = new File(dirs[i], pCmd + ".bat");
                if (!cmd.exists()) continue;
                return cmd.getCanonicalPath();
            }
            cmd = new File(dirs[i], pCmd);
            if (!cmd.exists()) continue;
            return cmd.getCanonicalPath();
        }
        throw new FileNotFoundException(pCmd);
    }

    static {
        iGlobalSearchPath = System.getenv("IM4JAVA_TOOLPATH");
    }
}

