/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.test;

import com.github.geko444.im4java.core.ConvertCmd;
import com.github.geko444.im4java.core.DisplayCmd;
import com.github.geko444.im4java.core.IMOperation;
import com.github.geko444.im4java.process.ProcessEvent;
import com.github.geko444.im4java.process.ProcessEventListener;
import com.github.geko444.im4java.test.AbstractTestCase;

public class TestCase16
extends AbstractTestCase {
    @Override
    public String getDescription() {
        return "asynchronous execution";
    }

    public static void main(String[] args) {
        TestCase16 tc = new TestCase16();
        tc.runTest(args);
    }

    @Override
    public void run() throws Exception {
        System.err.println("16. Testing asynchronous execution ...");
        IMOperation op = new IMOperation();
        op.size(400, 200);
        op.addImage("gradient:red", iTmpImage);
        ConvertCmd convert = new ConvertCmd();
        convert.run(op, new Object[0]);
        DisplayCmd display = new DisplayCmd();
        display.setAsyncMode(true);
        AsyncTestProcessEventListener pl = new AsyncTestProcessEventListener();
        display.addProcessEventListener(pl);
        IMOperation dispOp = new IMOperation();
        dispOp.addImage(iTmpImage);
        display.run(dispOp, new Object[0]);
        for (int i = 0; i < 10; ++i) {
            System.err.println("sleeping for one second...");
            Thread.sleep(1000L);
            if (!pl.isRunning()) break;
        }
        pl.destroy();
    }

    class AsyncTestProcessEventListener
    implements ProcessEventListener {
        private Process iProcess = null;
        private boolean isTerminated = false;

        AsyncTestProcessEventListener() {
        }

        @Override
        public void processInitiated(ProcessEvent pEvent) {
            System.err.println("process initiated");
        }

        @Override
        public void processStarted(ProcessEvent pEvent) {
            System.err.println("process started");
            this.isTerminated = false;
            this.iProcess = pEvent.getProcess();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processTerminated(ProcessEvent pEvent) {
            System.err.println("process terminated");
            Process process = this.iProcess;
            synchronized (process) {
                this.iProcess = null;
            }
            this.isTerminated = true;
            if (pEvent.getException() != null) {
                Exception e = pEvent.getException();
                System.err.println("Process terminated with: " + e.getMessage());
            } else {
                System.out.println("async process terminated with rc: " + pEvent.getReturnCode());
            }
        }

        public boolean isRunning() {
            return !this.isTerminated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            try {
                Process process = this.iProcess;
                synchronized (process) {
                    this.iProcess.destroy();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

