/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.utils;

import com.github.geko444.im4java.utils.BaseFilter;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;

public class ExtensionFilter
extends BaseFilter {
    public static final ExtensionFilter STANDARD_IMAGES = new ExtensionFilter("jpg", "jpeg", "tif", "tiff", "png", "gif", "bmp");
    public static final ExtensionFilter RAW_IMAGES = new ExtensionFilter("3fr", "arw", "srf", "sr2", "bay", "crw", "cr2", "cap", "tif", "iiq", "eip", "dcs", "dcr", "drf", "k25", "kdc", "dng", "erf", "fff", "mef", "mos", "mrw", "nef", "nrw", "orf", "ptx", "pef", "pxn", "R3D", "raf", "raw", "rw2", "rwl", "rwz", "x3f");
    private HashSet<String> iExtensions = null;

    public ExtensionFilter(String ... pExt) {
        this.iExtensions = new HashSet(pExt.length);
        for (String ext : pExt) {
            this.iExtensions.add(ext.toUpperCase(Locale.ENGLISH));
        }
    }

    public ExtensionFilter(Collection<String> pExt) {
        this.iExtensions = new HashSet(pExt.size());
        for (String ext : pExt) {
            this.iExtensions.add(ext.toUpperCase(Locale.ENGLISH));
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        File f = new File(dir.getPath() + File.separatorChar + name);
        if (f.isDirectory()) {
            return this.acceptDir(dir, name);
        }
        int extIndex = name.lastIndexOf(46);
        if (extIndex == -1) {
            return false;
        }
        String ext = name.substring(extIndex + 1).toUpperCase(Locale.ENGLISH);
        return this.iExtensions.contains(ext);
    }
}

