/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.utils;

import java.io.File;

public class FilenamePatternResolver {
    private String iTemplate;
    private char iEscChar;

    public FilenamePatternResolver(String pTemplate) {
        this(pTemplate, '%');
    }

    public FilenamePatternResolver(String pTemplate, char pEscChar) {
        this.iTemplate = pTemplate;
        this.iEscChar = pEscChar;
    }

    public String createName(String pFilename) {
        StringBuilder result = new StringBuilder(this.iTemplate);
        File pFile = new File(pFilename);
        int index = result.indexOf(this.iEscChar + "D");
        if (index > -1) {
            result.replace(index, index + 2, this.getDrive(pFile));
        }
        if ((index = result.indexOf(this.iEscChar + "P")) > -1) {
            result.replace(index, index + 2, this.getFullpath(pFile));
        }
        if ((index = result.indexOf(this.iEscChar + "p")) > -1) {
            result.replace(index, index + 2, this.getPath(pFile));
        }
        if ((index = result.indexOf(this.iEscChar + "F")) > -1) {
            result.replace(index, index + 2, this.getFullname(pFile));
        }
        if ((index = result.indexOf(this.iEscChar + "f")) > -1) {
            result.replace(index, index + 2, this.getName(pFile));
        }
        if ((index = result.indexOf(this.iEscChar + "e")) > -1) {
            result.replace(index, index + 2, this.getExt(pFile));
        }
        return result.toString();
    }

    public String getDrive(File pFile) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            String path = pFile.getAbsolutePath();
            if (path == null) {
                return "";
            }
            return path.substring(0, 1);
        }
        return "";
    }

    public String getFullpath(File pFile) {
        String path = pFile.getParent();
        if (path == null) {
            return "";
        }
        return path;
    }

    public String getPath(File pFile) {
        String path = pFile.getParent();
        if (path == null) {
            return "";
        }
        int index = path.lastIndexOf(File.separatorChar);
        if (index == path.length() - 1) {
            index = path.lastIndexOf(File.separatorChar, index);
        }
        return path.substring(index + 1);
    }

    public String getFullname(File pFile) {
        String name = pFile.getName();
        if (name == null) {
            return "";
        }
        return name;
    }

    public String getName(File pFile) {
        String name = pFile.getName();
        if (name == null) {
            return "";
        }
        int index = name.lastIndexOf(46);
        if (index > -1) {
            return name.substring(0, index);
        }
        return name;
    }

    public String getExt(File pFile) {
        String name = pFile.getName();
        if (name == null) {
            return "";
        }
        int index = name.lastIndexOf(46);
        if (index > -1) {
            return name.substring(index + 1);
        }
        return "";
    }
}

