/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.core.impl;

import io.api.etherscan.core.IAccountApi;
import io.api.etherscan.core.impl.BasicProvider;
import io.api.etherscan.error.ApiException;
import io.api.etherscan.error.EtherScanException;
import io.api.etherscan.executor.IHttpExecutor;
import io.api.etherscan.manager.IQueueManager;
import io.api.etherscan.model.Balance;
import io.api.etherscan.model.Block;
import io.api.etherscan.model.TokenBalance;
import io.api.etherscan.model.Tx;
import io.api.etherscan.model.TxInternal;
import io.api.etherscan.model.TxToken;
import io.api.etherscan.model.utility.BalanceResponseTO;
import io.api.etherscan.model.utility.BaseListResponseTO;
import io.api.etherscan.model.utility.BlockParam;
import io.api.etherscan.model.utility.BlockResponseTO;
import io.api.etherscan.model.utility.StringResponseTO;
import io.api.etherscan.model.utility.TxInternalResponseTO;
import io.api.etherscan.model.utility.TxResponseTO;
import io.api.etherscan.model.utility.TxTokenResponseTO;
import io.api.etherscan.util.BasicUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AccountApiProvider
extends BasicProvider
implements IAccountApi {
    private static final int OFFSET_MAX = 10000;
    private static final String ACT_BALANCE_ACTION = "&action=balance";
    private static final String ACT_TOKEN_BALANCE_PARAM = "&action=tokenbalance";
    private static final String ACT_BALANCE_MULTI_ACTION = "&action=balancemulti";
    private static final String ACT_TX_ACTION = "&action=txlist";
    private static final String ACT_TX_INTERNAL_ACTION = "&action=txlistinternal";
    private static final String ACT_TX_TOKEN_ACTION = "&action=tokentx";
    private static final String ACT_TX_NFT_TOKEN_ACTION = "&action=tokennfttx";
    private static final String ACT_MINED_ACTION = "&action=getminedblocks";
    private static final String BLOCK_TYPE_PARAM = "&blocktype=blocks";
    private static final String CONTRACT_PARAM = "&contractaddress=";
    private static final String START_BLOCK_PARAM = "&startblock=";
    private static final String TAG_LATEST_PARAM = "&tag=latest";
    private static final String END_BLOCK_PARAM = "&endblock=";
    private static final String SORT_DESC_PARAM = "&sort=desc";
    private static final String SORT_ASC_PARAM = "&sort=asc";
    private static final String ADDRESS_PARAM = "&address=";
    private static final String TXHASH_PARAM = "&txhash=";
    private static final String OFFSET_PARAM = "&offset=";
    private static final String PAGE_PARAM = "&page=";

    AccountApiProvider(IQueueManager queueManager, String baseUrl, IHttpExecutor executor) {
        super(queueManager, "account", baseUrl, executor);
    }

    @Override
    @NotNull
    public Balance balance(String address) throws ApiException {
        BasicUtils.validateAddress(address);
        String urlParams = "&action=balance&tag=latest&address=" + address;
        StringResponseTO response = this.getRequest(urlParams, StringResponseTO.class);
        if (response.getStatus() != 1) {
            throw new EtherScanException(response);
        }
        return new Balance(address, new BigInteger(response.getResult()));
    }

    @Override
    @NotNull
    public TokenBalance balance(String address, String contract) throws ApiException {
        BasicUtils.validateAddress(address);
        BasicUtils.validateAddress(contract);
        String urlParams = "&action=tokenbalance&address=" + address + CONTRACT_PARAM + contract;
        StringResponseTO response = this.getRequest(urlParams, StringResponseTO.class);
        if (response.getStatus() != 1) {
            throw new EtherScanException(response);
        }
        return new TokenBalance(address, new BigInteger(response.getResult()), contract);
    }

    @Override
    @NotNull
    public List<Balance> balances(List<String> addresses) throws ApiException {
        if (BasicUtils.isEmpty(addresses)) {
            return Collections.emptyList();
        }
        BasicUtils.validateAddresses(addresses);
        ArrayList<Balance> balances = new ArrayList<Balance>();
        List<List<String>> addressesAsBatches = BasicUtils.partition(addresses, 20);
        for (List<String> batch : addressesAsBatches) {
            String urlParams = "&action=balancemulti&tag=latest&address=" + this.toAddressParam(batch);
            BalanceResponseTO response = this.getRequest(urlParams, BalanceResponseTO.class);
            if (response.getStatus() != 1) {
                throw new EtherScanException(response);
            }
            if (BasicUtils.isEmpty(response.getResult())) continue;
            balances.addAll(response.getResult().stream().map(Balance::of).collect(Collectors.toList()));
        }
        return balances;
    }

    private String toAddressParam(List<String> addresses) {
        return addresses.stream().collect(Collectors.joining(","));
    }

    @Override
    @NotNull
    public List<Tx> txs(String address) throws ApiException {
        return this.txs(address, 0L);
    }

    @Override
    @NotNull
    public List<Tx> txs(String address, long startBlock) throws ApiException {
        return this.txs(address, startBlock, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public List<Tx> txs(String address, long startBlock, long endBlock) throws ApiException {
        BasicUtils.validateAddress(address);
        BlockParam blocks = BasicUtils.compensateBlocks(startBlock, endBlock);
        String offsetParam = "&page=%s&offset=10000";
        String blockParam = START_BLOCK_PARAM + blocks.start() + END_BLOCK_PARAM + blocks.end();
        String urlParams = "&action=txlist&page=%s&offset=10000&address=" + address + blockParam + SORT_ASC_PARAM;
        return this.getRequestUsingOffset(urlParams, TxResponseTO.class);
    }

    private <T, R extends BaseListResponseTO> List<T> getRequestUsingOffset(String urlParams, Class<R> tClass) throws ApiException {
        BaseListResponseTO response;
        ArrayList result = new ArrayList();
        int page = 1;
        do {
            String formattedUrl = String.format(urlParams, page++);
            response = (BaseListResponseTO)this.getRequest(formattedUrl, tClass);
            BasicUtils.validateTxResponse(response);
            if (BasicUtils.isEmpty(response.getResult())) break;
            result.addAll(response.getResult());
        } while (response.getResult().size() >= 10000);
        return result;
    }

    @Override
    @NotNull
    public List<TxInternal> txsInternal(String address) throws ApiException {
        return this.txsInternal(address, 0L);
    }

    @Override
    @NotNull
    public List<TxInternal> txsInternal(String address, long startBlock) throws ApiException {
        return this.txsInternal(address, startBlock, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public List<TxInternal> txsInternal(String address, long startBlock, long endBlock) throws ApiException {
        BasicUtils.validateAddress(address);
        BlockParam blocks = BasicUtils.compensateBlocks(startBlock, endBlock);
        String offsetParam = "&page=%s&offset=10000";
        String blockParam = START_BLOCK_PARAM + blocks.start() + END_BLOCK_PARAM + blocks.end();
        String urlParams = "&action=txlistinternal&page=%s&offset=10000&address=" + address + blockParam + SORT_ASC_PARAM;
        return this.getRequestUsingOffset(urlParams, TxInternalResponseTO.class);
    }

    @Override
    @NotNull
    public List<TxInternal> txsInternalByHash(String txhash) throws ApiException {
        BasicUtils.validateTxHash(txhash);
        String urlParams = "&action=txlistinternal&txhash=" + txhash;
        TxInternalResponseTO response = this.getRequest(urlParams, TxInternalResponseTO.class);
        BasicUtils.validateTxResponse(response);
        return BasicUtils.isEmpty(response.getResult()) ? Collections.emptyList() : response.getResult();
    }

    @Override
    @NotNull
    public List<TxToken> txsToken(String address) throws ApiException {
        return this.txsToken(address, 0L);
    }

    @Override
    @NotNull
    public List<TxToken> txsToken(String address, long startBlock) throws ApiException {
        return this.txsToken(address, startBlock, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public List<TxToken> txsToken(String address, long startBlock, long endBlock) throws ApiException {
        BasicUtils.validateAddress(address);
        BlockParam blocks = BasicUtils.compensateBlocks(startBlock, endBlock);
        String offsetParam = "&page=%s&offset=10000";
        String blockParam = START_BLOCK_PARAM + blocks.start() + END_BLOCK_PARAM + blocks.end();
        String urlParams = "&action=tokentx&page=%s&offset=10000&address=" + address + blockParam + SORT_ASC_PARAM;
        return this.getRequestUsingOffset(urlParams, TxTokenResponseTO.class);
    }

    @Override
    @NotNull
    public List<TxToken> txsNftToken(String address) throws ApiException {
        return this.txsNftToken(address, 0L);
    }

    @Override
    @NotNull
    public List<TxToken> txsNftToken(String address, long startBlock) throws ApiException {
        return this.txsNftToken(address, startBlock, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public List<TxToken> txsNftToken(String address, long startBlock, long endBlock) throws ApiException {
        BasicUtils.validateAddress(address);
        BlockParam blocks = BasicUtils.compensateBlocks(startBlock, endBlock);
        String offsetParam = "&page=%s&offset=10000";
        String blockParam = START_BLOCK_PARAM + blocks.start() + END_BLOCK_PARAM + blocks.end();
        String urlParams = "&action=tokennfttx&page=%s&offset=10000&address=" + address + blockParam + SORT_ASC_PARAM;
        return this.getRequestUsingOffset(urlParams, TxTokenResponseTO.class);
    }

    @Override
    @NotNull
    public List<Block> minedBlocks(String address) throws ApiException {
        BasicUtils.validateAddress(address);
        String offsetParam = "&page=%s&offset=10000";
        String urlParams = "&action=getminedblocks&page=%s&offset=10000&blocktype=blocks&address=" + address;
        return this.getRequestUsingOffset(urlParams, BlockResponseTO.class);
    }
}

