/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.core.impl;

import io.api.etherscan.core.IContractApi;
import io.api.etherscan.core.impl.BasicProvider;
import io.api.etherscan.error.ApiException;
import io.api.etherscan.error.EtherScanException;
import io.api.etherscan.executor.IHttpExecutor;
import io.api.etherscan.manager.IQueueManager;
import io.api.etherscan.model.Abi;
import io.api.etherscan.model.utility.StringResponseTO;
import io.api.etherscan.util.BasicUtils;
import org.jetbrains.annotations.NotNull;

public class ContractApiProvider
extends BasicProvider
implements IContractApi {
    private static final String ACT_ABI_PARAM = "&action=getabi";
    private static final String ADDRESS_PARAM = "&address=";

    ContractApiProvider(IQueueManager queueManager, String baseUrl, IHttpExecutor executor) {
        super(queueManager, "contract", baseUrl, executor);
    }

    @Override
    @NotNull
    public Abi contractAbi(String address) throws ApiException {
        BasicUtils.validateAddress(address);
        String urlParam = "&action=getabi&address=" + address;
        StringResponseTO response = this.getRequest(urlParam, StringResponseTO.class);
        if (response.getStatus() != 1 && "NOTOK".equals(response.getMessage())) {
            throw new EtherScanException(response);
        }
        return response.getResult().startsWith("Contract sou") ? Abi.nonVerified() : Abi.verified(response.getResult());
    }
}

