/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.model;

import io.api.etherscan.model.Wei;
import io.api.etherscan.model.utility.BalanceTO;
import java.math.BigInteger;
import java.util.Objects;

public class Balance {
    private final Wei balance;
    private final String address;

    public Balance(String address, BigInteger balance) {
        this.address = address;
        this.balance = new Wei(balance);
    }

    public static Balance of(BalanceTO balance) {
        return new Balance(balance.getAccount(), new BigInteger(balance.getBalance()));
    }

    public String getAddress() {
        return this.address;
    }

    public BigInteger getWei() {
        return this.balance.getValue();
    }

    public BigInteger getKwei() {
        return this.balance.asKwei();
    }

    public BigInteger getMwei() {
        return this.balance.asMwei();
    }

    public BigInteger getGwei() {
        return this.balance.asGwei();
    }

    public BigInteger getEther() {
        return this.balance.asEther();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Balance balance1 = (Balance)o;
        if (!this.balance.equals(balance1.balance)) {
            return false;
        }
        return Objects.equals(this.address, balance1.address);
    }

    public int hashCode() {
        int result = this.balance.hashCode();
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Balance{address='" + this.address + '\'' + ", balance=" + this.balance + '}';
    }
}

