/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model;

import com.google.gson.annotations.Expose;
import io.goodforgod.api.etherscan.model.Wei;
import io.goodforgod.api.etherscan.util.BasicUtils;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Objects;

public class Log {
    private String blockNumber;
    @Expose(deserialize=false, serialize=false)
    private Long _blockNumber;
    private String address;
    private String transactionHash;
    private String transactionIndex;
    @Expose(deserialize=false, serialize=false)
    private Long _transactionIndex;
    private String timeStamp;
    @Expose(deserialize=false, serialize=false)
    private LocalDateTime _timeStamp;
    private String data;
    private String gasPrice;
    @Expose(deserialize=false, serialize=false)
    private Wei _gasPrice;
    private String gasUsed;
    @Expose(deserialize=false, serialize=false)
    private Wei _gasUsed;
    private List<String> topics;
    private String logIndex;
    @Expose(deserialize=false, serialize=false)
    private Long _logIndex;

    protected Log() {
    }

    public Long getBlockNumber() {
        if (this._blockNumber == null && !BasicUtils.isEmpty(this.blockNumber)) {
            this._blockNumber = BasicUtils.parseHex(this.blockNumber).longValue();
        }
        return this._blockNumber;
    }

    public String getAddress() {
        return this.address;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public Long getTransactionIndex() {
        if (this._transactionIndex == null && !BasicUtils.isEmpty(this.transactionIndex)) {
            this._transactionIndex = BasicUtils.parseHex(this.transactionIndex).longValue();
        }
        return this._transactionIndex;
    }

    public LocalDateTime getTimeStamp() {
        if (this._timeStamp == null && !BasicUtils.isEmpty(this.timeStamp)) {
            long formatted = this.getTimeStampAsSeconds();
            this._timeStamp = LocalDateTime.ofEpochSecond(formatted, 0, ZoneOffset.UTC);
        }
        return this._timeStamp;
    }

    public Long getTimeStampAsSeconds() {
        if (BasicUtils.isEmpty(this.timeStamp)) {
            return null;
        }
        return this.timeStamp.charAt(0) == '0' && this.timeStamp.charAt(1) == 'x' ? BasicUtils.parseHex(this.timeStamp).longValue() : Long.parseLong(this.timeStamp);
    }

    public String getData() {
        return this.data;
    }

    public Wei getGasPrice() {
        if (!BasicUtils.isEmpty(this.gasPrice)) {
            this._gasPrice = Wei.ofWei(BasicUtils.parseHex(this.gasPrice));
        }
        return this._gasPrice;
    }

    public Wei getGasUsed() {
        if (!BasicUtils.isEmpty(this.gasUsed)) {
            this._gasUsed = Wei.ofWei(BasicUtils.parseHex(this.gasUsed));
        }
        return this._gasUsed;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public Long getLogIndex() {
        if (this._logIndex == null && !BasicUtils.isEmpty(this.logIndex)) {
            this._logIndex = BasicUtils.parseHex(this.logIndex).longValue();
        }
        return this._logIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Log)) {
            return false;
        }
        Log log = (Log)o;
        return Objects.equals(this.blockNumber, log.blockNumber) && Objects.equals(this.address, log.address) && Objects.equals(this.transactionHash, log.transactionHash) && Objects.equals(this.transactionIndex, log.transactionIndex) && Objects.equals(this.logIndex, log.logIndex);
    }

    public int hashCode() {
        return Objects.hash(this.blockNumber, this.address, this.transactionHash, this.transactionIndex, this.logIndex);
    }

    public String toString() {
        return "Log{blockNumber=" + this.blockNumber + ", address=" + this.address + ", transactionHash=" + this.transactionHash + ", transactionIndex=" + this.transactionIndex + ", timeStamp=" + this.timeStamp + ", data=" + this.data + ", gasPrice=" + this.gasPrice + ", gasUsed=" + this.gasUsed + ", topics=" + this.topics + ", logIndex=" + this.logIndex + '}';
    }

    public static LogBuilder builder() {
        return new LogBuilder();
    }

    public static final class LogBuilder {
        private Long blockNumber;
        private String address;
        private String transactionHash;
        private Long transactionIndex;
        private LocalDateTime timeStamp;
        private String data;
        private Wei gasPrice;
        private Wei gasUsed;
        private List<String> topics;
        private Long logIndex;

        private LogBuilder() {
        }

        public LogBuilder withBlockNumber(Long blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        public LogBuilder withAddress(String address) {
            this.address = address;
            return this;
        }

        public LogBuilder withTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        public LogBuilder withTransactionIndex(Long transactionIndex) {
            this.transactionIndex = transactionIndex;
            return this;
        }

        public LogBuilder withTimeStamp(LocalDateTime timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public LogBuilder withData(String data) {
            this.data = data;
            return this;
        }

        public LogBuilder withGasPrice(Wei gasPrice) {
            this.gasPrice = gasPrice;
            return this;
        }

        public LogBuilder withGasUsed(Wei gasUsed) {
            this.gasUsed = gasUsed;
            return this;
        }

        public LogBuilder withTopics(List<String> topics) {
            this.topics = topics;
            return this;
        }

        public LogBuilder withLogIndex(Long logIndex) {
            this.logIndex = logIndex;
            return this;
        }

        public Log build() {
            Log log = new Log();
            log.address = this.address;
            if (this.gasPrice != null) {
                log._gasPrice = this.gasPrice;
            }
            log._logIndex = this.logIndex;
            log._transactionIndex = this.transactionIndex;
            log.blockNumber = String.valueOf(this.blockNumber);
            log.transactionIndex = String.valueOf(this.transactionIndex);
            if (this.timeStamp != null) {
                log.timeStamp = String.valueOf(this.timeStamp.toEpochSecond(ZoneOffset.UTC));
                log._timeStamp = this.timeStamp;
            }
            log.data = this.data;
            if (this.gasUsed != null) {
                log._gasUsed = this.gasUsed;
            }
            log.logIndex = String.valueOf(this.logIndex);
            log._blockNumber = this.blockNumber;
            log.topics = this.topics;
            log.transactionHash = this.transactionHash;
            return log;
        }
    }
}

