/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model.query;

import io.goodforgod.api.etherscan.error.EtherScanLogQueryException;
import io.goodforgod.api.etherscan.model.query.LogOp;
import io.goodforgod.api.etherscan.model.query.LogQuery;
import io.goodforgod.api.etherscan.model.query.LogQueryImpl;
import io.goodforgod.api.etherscan.model.query.LogTopicBuilder;
import org.jetbrains.annotations.NotNull;

public final class LogTopicQuadro
implements LogTopicBuilder {
    private final String address;
    private final long startBlock;
    private final long endBlock;
    private final String topic0;
    private final String topic1;
    private final String topic2;
    private final String topic3;
    private LogOp topic0_1_opr;
    private LogOp topic1_2_opr;
    private LogOp topic2_3_opr;
    private LogOp topic0_2_opr;
    private LogOp topic0_3_opr;
    private LogOp topic1_3_opr;

    LogTopicQuadro(String address, long startBlock, long endBlock, String topic0, String topic1, String topic2, String topic3) {
        this.address = address;
        this.startBlock = startBlock;
        this.endBlock = endBlock;
        this.topic0 = topic0;
        this.topic1 = topic1;
        this.topic2 = topic2;
        this.topic3 = topic3;
    }

    public LogTopicQuadro setOpTopic0_1(LogOp topic0_1_opr) {
        this.topic0_1_opr = topic0_1_opr;
        return this;
    }

    public LogTopicQuadro setOpTopic1_2(LogOp topic1_2_opr) {
        this.topic1_2_opr = topic1_2_opr;
        return this;
    }

    public LogTopicQuadro setOpTopic2_3(LogOp topic2_3_opr) {
        this.topic2_3_opr = topic2_3_opr;
        return this;
    }

    public LogTopicQuadro setOpTopic0_2(LogOp topic0_2_opr) {
        this.topic0_2_opr = topic0_2_opr;
        return this;
    }

    public LogTopicQuadro setOpTopic0_3(LogOp topic0_3_opr) {
        this.topic0_3_opr = topic0_3_opr;
        return this;
    }

    public LogTopicQuadro setOpTopic1_3(LogOp topic1_3_opr) {
        this.topic1_3_opr = topic1_3_opr;
        return this;
    }

    @Override
    @NotNull
    public LogQuery build() {
        if (this.topic0_1_opr == null) {
            throw new EtherScanLogQueryException("topic0_1_opr can not be null.");
        }
        if (this.topic0_2_opr == null) {
            throw new EtherScanLogQueryException("topic0_2_opr can not be null.");
        }
        if (this.topic0_3_opr == null) {
            throw new EtherScanLogQueryException("topic0_3_opr can not be null.");
        }
        if (this.topic1_2_opr == null) {
            throw new EtherScanLogQueryException("topic1_2_opr can not be null.");
        }
        if (this.topic2_3_opr == null) {
            throw new EtherScanLogQueryException("topic2_3_opr can not be null.");
        }
        if (this.topic1_3_opr == null) {
            throw new EtherScanLogQueryException("topic1_3_opr can not be null.");
        }
        return new LogQueryImpl("&address=" + this.address + "&fromBlock=" + this.startBlock + "&toBlock=" + this.endBlock + "&topic0=" + this.topic0 + "&topic1=" + this.topic1 + "&topic2=" + this.topic2 + "&topic3=" + this.topic3 + "&topic0_1_opr=" + this.topic0_1_opr.getOperation() + "&topic0_2_opr=" + this.topic0_2_opr.getOperation() + "&topic0_3_opr=" + this.topic0_2_opr.getOperation() + "&topic1_2_opr=" + this.topic0_2_opr.getOperation() + "&topic1_3_opr=" + this.topic1_2_opr.getOperation() + "&topic2_3_opr=" + this.topic0_2_opr.getOperation());
    }
}

