/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan;

import io.goodforgod.api.etherscan.Converter;
import io.goodforgod.api.etherscan.error.EtherScanException;
import io.goodforgod.api.etherscan.error.EtherScanParseException;
import io.goodforgod.api.etherscan.error.EtherScanRateLimitException;
import io.goodforgod.api.etherscan.error.EtherScanResponseException;
import io.goodforgod.api.etherscan.http.EthHttpClient;
import io.goodforgod.api.etherscan.http.EthResponse;
import io.goodforgod.api.etherscan.manager.RequestQueueManager;
import io.goodforgod.api.etherscan.model.response.BaseListResponseTO;
import io.goodforgod.api.etherscan.model.response.StringResponseTO;
import io.goodforgod.api.etherscan.util.BasicUtils;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class BasicProvider {
    private static final String MAX_RATE_LIMIT_REACHED = "Max rate limit reached";
    private static final int OFFSET_MAX = 9999;
    static final int MAX_END_BLOCK = Integer.MAX_VALUE;
    static final int MIN_START_BLOCK = 0;
    static final String ACT_PREFIX = "&action=";
    private final String module;
    private final String baseUrl;
    private final EthHttpClient executor;
    private final RequestQueueManager queue;
    private final Converter converter;
    private final int retryCountLimit;

    public BasicProvider(RequestQueueManager requestQueueManager, String module, String baseUrl, EthHttpClient ethHttpClient, Converter converter, int retryCountLimit) {
        this.queue = requestQueueManager;
        this.module = "&module=" + module;
        this.baseUrl = baseUrl;
        this.executor = ethHttpClient;
        this.converter = converter;
        this.retryCountLimit = retryCountLimit;
    }

    protected <T> T convert(byte[] json, Class<T> tClass) {
        try {
            T t = this.converter.fromJson(json, tClass);
            if (t instanceof StringResponseTO && ((StringResponseTO)t).getResult().startsWith(MAX_RATE_LIMIT_REACHED)) {
                throw new EtherScanRateLimitException(((StringResponseTO)t).getResult());
            }
            return t;
        }
        catch (Exception e) {
            StringResponseTO response = this.converter.fromJson(json, StringResponseTO.class);
            if (response.getResult() != null && response.getStatus() == 0) {
                if (response.getResult().startsWith(MAX_RATE_LIMIT_REACHED)) {
                    throw new EtherScanRateLimitException(response.getResult());
                }
                throw new EtherScanResponseException(response);
            }
            String jsonAsString = new String(json, StandardCharsets.UTF_8);
            throw new EtherScanParseException(e.getMessage() + ", for response: " + jsonAsString, e.getCause(), jsonAsString);
        }
    }

    protected int getMaximumOffset() {
        return 9999;
    }

    protected <T, R extends BaseListResponseTO<T>> List<T> getRequestUsingOffset(String urlParams, Class<R> tClass) throws EtherScanException {
        BaseListResponseTO response;
        ArrayList result = new ArrayList();
        int page = 1;
        do {
            String formattedUrl = String.format(urlParams, page++);
            response = (BaseListResponseTO)this.getResponse(formattedUrl, tClass);
            BasicUtils.validateTxResponse(response);
            if (BasicUtils.isEmpty(response.getResult())) break;
            result.addAll(response.getResult());
        } while (response.getResult().size() >= this.getMaximumOffset());
        return result;
    }

    protected EthResponse getResponse(String urlParameters) {
        this.queue.takeTurn();
        URI uri = URI.create(this.baseUrl + this.module + urlParameters);
        return this.executor.get(uri);
    }

    protected EthResponse postRequest(String urlParameters, String dataToPost) {
        this.queue.takeTurn();
        URI uri = URI.create(this.baseUrl + this.module + urlParameters);
        return this.executor.post(uri, dataToPost.getBytes(StandardCharsets.UTF_8));
    }

    protected <T> T getResponse(String urlParameters, Class<T> tClass) {
        return this.getResponse(urlParameters, tClass, 0);
    }

    protected <T> T getResponse(String urlParameters, Class<T> tClass, int retryCount) {
        try {
            EthResponse response = this.getResponse(urlParameters);
            return this.convert(response.body(), tClass);
        }
        catch (Exception e) {
            if (retryCount < this.retryCountLimit) {
                try {
                    Thread.sleep(1150L);
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException(ex);
                }
                return this.getResponse(urlParameters, tClass, retryCount + 1);
            }
            throw e;
        }
    }

    protected <T> T postRequest(String urlParameters, String dataToPost, Class<T> tClass) {
        return this.postRequest(urlParameters, dataToPost, tClass, 0);
    }

    protected <T> T postRequest(String urlParameters, String dataToPost, Class<T> tClass, int retryCount) {
        try {
            EthResponse response = this.postRequest(urlParameters, dataToPost);
            return this.convert(response.body(), tClass);
        }
        catch (EtherScanRateLimitException e) {
            if (retryCount < this.retryCountLimit) {
                try {
                    Thread.sleep(1150L);
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException(ex);
                }
                return this.postRequest(urlParameters, dataToPost, tClass, retryCount + 1);
            }
            throw e;
        }
    }
}

