/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan;

import io.goodforgod.api.etherscan.BasicProvider;
import io.goodforgod.api.etherscan.Converter;
import io.goodforgod.api.etherscan.GasTrackerAPI;
import io.goodforgod.api.etherscan.error.EtherScanException;
import io.goodforgod.api.etherscan.error.EtherScanResponseException;
import io.goodforgod.api.etherscan.http.EthHttpClient;
import io.goodforgod.api.etherscan.manager.RequestQueueManager;
import io.goodforgod.api.etherscan.model.GasOracle;
import io.goodforgod.api.etherscan.model.Wei;
import io.goodforgod.api.etherscan.model.response.GasEstimateResponseTO;
import io.goodforgod.api.etherscan.model.response.GasOracleResponseTO;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public class GasTrackerAPIProvider
extends BasicProvider
implements GasTrackerAPI {
    private static final String ACT_GAS_ORACLE_PARAM = "&action=gasoracle";
    private static final String ACT_GAS_ESTIMATE_PARAM = "&action=gasestimate";
    private static final String GASPRICE_PARAM = "&gasprice=";

    public GasTrackerAPIProvider(RequestQueueManager queue, String baseUrl, EthHttpClient ethHttpClient, Converter converter, int retryCount) {
        super(queue, "gastracker", baseUrl, ethHttpClient, converter, retryCount);
    }

    @Override
    @NotNull
    public Duration estimate(@NotNull Wei wei) throws EtherScanException {
        String urlParams = "&action=gasestimate&gasprice=" + wei.asWei().toString();
        GasEstimateResponseTO response = this.getResponse(urlParams, GasEstimateResponseTO.class);
        if (response.getStatus() != 1) {
            throw new EtherScanResponseException(response);
        }
        return Duration.ofSeconds(Long.parseLong(response.getResult()));
    }

    @Override
    @NotNull
    public GasOracle oracle() throws EtherScanException {
        GasOracleResponseTO response = this.getResponse(ACT_GAS_ORACLE_PARAM, GasOracleResponseTO.class);
        if (response.getStatus() != 1) {
            throw new EtherScanResponseException(response);
        }
        return response.getResult();
    }
}

