/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan;

import io.goodforgod.api.etherscan.BasicProvider;
import io.goodforgod.api.etherscan.Converter;
import io.goodforgod.api.etherscan.StatisticAPI;
import io.goodforgod.api.etherscan.error.EtherScanException;
import io.goodforgod.api.etherscan.error.EtherScanResponseException;
import io.goodforgod.api.etherscan.http.EthHttpClient;
import io.goodforgod.api.etherscan.manager.RequestQueueManager;
import io.goodforgod.api.etherscan.model.EthSupply;
import io.goodforgod.api.etherscan.model.Price;
import io.goodforgod.api.etherscan.model.Wei;
import io.goodforgod.api.etherscan.model.response.EthSupplyResponseTO;
import io.goodforgod.api.etherscan.model.response.PriceResponseTO;
import io.goodforgod.api.etherscan.model.response.StringResponseTO;
import io.goodforgod.api.etherscan.util.BasicUtils;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;

public class StatisticAPIProvider
extends BasicProvider
implements StatisticAPI {
    private static final String ACT_SUPPLY_PARAM = "&action=ethsupply";
    private static final String ACT_SUPPLY2_PARAM = "&action=ethsupply2";
    private static final String ACT_TOKEN_SUPPLY_PARAM = "&action=tokensupply";
    private static final String ACT_LASTPRICE_PARAM = "&action=ethprice";
    private static final String CONTRACT_ADDRESS_PARAM = "&contractaddress=";

    public StatisticAPIProvider(RequestQueueManager queue, String baseUrl, EthHttpClient executor, Converter converter, int retry) {
        super(queue, "stats", baseUrl, executor, converter, retry);
    }

    @Override
    @NotNull
    public Wei supply() throws EtherScanException {
        StringResponseTO response = this.getResponse(ACT_SUPPLY_PARAM, StringResponseTO.class);
        if (response.getStatus() != 1) {
            throw new EtherScanResponseException(response);
        }
        return Wei.ofWei(new BigInteger(response.getResult()));
    }

    @Override
    @NotNull
    public EthSupply supplyTotal() throws EtherScanException {
        EthSupplyResponseTO response = this.getResponse(ACT_SUPPLY2_PARAM, EthSupplyResponseTO.class);
        if (response.getStatus() != 1) {
            throw new EtherScanResponseException(response);
        }
        return response.getResult();
    }

    @Override
    @NotNull
    public Wei supply(@NotNull String contract) throws EtherScanException {
        BasicUtils.validateAddress(contract);
        String urlParams = "&action=tokensupply&contractaddress=" + contract;
        StringResponseTO response = this.getResponse(urlParams, StringResponseTO.class);
        if (response.getStatus() != 1) {
            throw new EtherScanResponseException(response);
        }
        return Wei.ofWei(new BigInteger(response.getResult()));
    }

    @Override
    @NotNull
    public Price priceLast() throws EtherScanException {
        PriceResponseTO response = this.getResponse(ACT_LASTPRICE_PARAM, PriceResponseTO.class);
        if (response.getStatus() != 1) {
            throw new EtherScanResponseException(response);
        }
        return response.getResult();
    }
}

