/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.manager.impl;

import io.goodforgod.api.etherscan.manager.RequestQueueManager;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class SemaphoreRequestQueueManager
implements RequestQueueManager,
AutoCloseable {
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final Semaphore semaphore = new Semaphore(0);
    private final long queueResetTimeInMillis;

    public SemaphoreRequestQueueManager(int size, Duration resetIn) {
        this.queueResetTimeInMillis = resetIn.toMillis();
        this.executorService.scheduleAtFixedRate(this.releaseLocks(size), resetIn.toMillis(), this.queueResetTimeInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void takeTurn() {
        try {
            this.semaphore.tryAcquire(this.queueResetTimeInMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private Runnable releaseLocks(int toRelease) {
        return () -> {
            int availablePermits = this.semaphore.availablePermits();
            int neededPermits = toRelease - availablePermits;
            if (neededPermits > 0) {
                this.semaphore.release(neededPermits);
            }
        };
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }
}

