/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.SchemaProvider;
import org.sqlite.parser.ast.BinaryExpr;
import org.sqlite.parser.ast.CompoundOperator;
import org.sqlite.parser.ast.CompoundSelect;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.FromClause;
import org.sqlite.parser.ast.FunctionCallExpr;
import org.sqlite.parser.ast.IdExpr;
import org.sqlite.parser.ast.InListExpr;
import org.sqlite.parser.ast.LikeExpr;
import org.sqlite.parser.ast.LiteralExpr;
import org.sqlite.parser.ast.OneSelect;
import org.sqlite.parser.ast.Operator;
import org.sqlite.parser.ast.QualifiedName;
import org.sqlite.parser.ast.ResultColumn;
import org.sqlite.parser.ast.Select;
import org.sqlite.parser.ast.SelectBody;
import org.sqlite.parser.ast.VariableExpr;

public class DefaultSchemaProvider
implements SchemaProvider {
    private final Connection conn;

    public DefaultSchemaProvider(Connection conn) {
        this.conn = Objects.requireNonNull(conn);
    }

    @Override
    public List<QualifiedName> findTables(String dbName, String tableNamePattern) throws SQLException {
        return this.findTables(dbName, tableNamePattern, true);
    }

    public List<QualifiedName> findTables(String dbName, String tableNamePattern, boolean all) throws SQLException {
        if ("sqlite_temp_master".equalsIgnoreCase(tableNamePattern)) {
            return Collections.singletonList(new QualifiedName("temp", tableNamePattern));
        }
        if ("sqlite_master".equalsIgnoreCase(tableNamePattern)) {
            if (dbName == null || dbName.isEmpty()) {
                return Collections.singletonList(new QualifiedName("main", tableNamePattern));
            }
            return Collections.singletonList(new QualifiedName(dbName, tableNamePattern));
        }
        List<String> dbNames = this.getDbNames(dbName);
        tableNamePattern = tableNamePattern == null ? "%" : tableNamePattern;
        List<QualifiedName> tbls = all ? new ArrayList() : Collections.emptyList();
        for (String catalog : dbNames) {
            Select select = DefaultSchemaProvider.sqlite_master(catalog, "name", all);
            PreparedStatement ps = this.conn.prepareStatement(select.toSql());
            Throwable throwable = null;
            try {
                ps.setString(1, tableNamePattern);
                ResultSet rs = ps.executeQuery();
                Throwable throwable2 = null;
                try {
                    while (rs.next()) {
                        QualifiedName qualifiedName = new QualifiedName(catalog, rs.getString(1));
                        if (!all) {
                            List<QualifiedName> list = Collections.singletonList(qualifiedName);
                            return list;
                        }
                        tbls.add(qualifiedName);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rs == null) continue;
                    DefaultSchemaProvider.$closeResource(throwable2, rs);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ps == null) continue;
                DefaultSchemaProvider.$closeResource(throwable, ps);
            }
        }
        return tbls;
    }

    @Override
    public String getDbName(String dbName, String tableName) throws SQLException {
        if (tableName == null) {
            return "temp";
        }
        List<QualifiedName> tableNames = this.findTables(dbName, tableName, false);
        if (tableNames.isEmpty()) {
            return "temp";
        }
        return tableNames.get((int)0).dbName;
    }

    @Override
    public List<String> getDbNames(String dbName) throws SQLException {
        List<Object> dbNames;
        block15: {
            if (dbName == null) {
                dbNames = new ArrayList(2);
                try (PreparedStatement database_list = this.conn.prepareStatement("PRAGMA database_list");
                     ResultSet rs = database_list.executeQuery();){
                    while (rs.next()) {
                        String name = rs.getString(2);
                        if ("temp".equalsIgnoreCase(name)) {
                            dbNames.add(0, name);
                            continue;
                        }
                        dbNames.add(name);
                    }
                    break block15;
                }
            }
            dbNames = dbName.isEmpty() ? Arrays.asList("temp", "main") : Collections.singletonList(dbName);
        }
        return dbNames;
    }

    @Override
    public String getSchema(String dbName, String tableName) throws SQLException {
        if ("sqlite_temp_master".equalsIgnoreCase(tableName)) {
            return "CREATE TEMP TABLE sqlite_temp_master (\n  type text,\n  name text,\n  tbl_name text,\n  rootpage integer,\n  sql text\n)";
        }
        if ("sqlite_master".equalsIgnoreCase(tableName)) {
            return "CREATE TABLE sqlite_master (\n  type text,\n  name text,\n  tbl_name text,\n  rootpage integer,\n  sql text\n)";
        }
        Select select = DefaultSchemaProvider.sqlite_master(dbName, "sql", false);
        try (PreparedStatement ps = this.conn.prepareStatement(select.toSql());){
            ps.setString(1, tableName);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    String string = rs.getString(1);
                    return string;
                }
            }
        }
        throw new SQLException("No such table: " + dbName + "." + tableName);
    }

    private static Select sqlite_master(String dbName, String column, boolean like) {
        QualifiedName qualifiedName;
        String sqlite_master;
        if ("temp".equalsIgnoreCase(dbName)) {
            sqlite_master = "sqlite_temp_master";
            qualifiedName = new QualifiedName(null, sqlite_master);
        } else {
            sqlite_master = "sqlite_master";
            qualifiedName = new QualifiedName(dbName, sqlite_master);
        }
        List<ResultColumn> columns = Collections.singletonList(ResultColumn.expr(new IdExpr(column), null));
        FromClause from = FromClause.from(qualifiedName);
        InListExpr typeEpr = new InListExpr(new IdExpr("type"), false, Arrays.asList(LiteralExpr.string("table"), LiteralExpr.string("view")));
        Expr nameExpr = like ? LikeExpr.like(new IdExpr("name"), new VariableExpr("1")) : new BinaryExpr(FunctionCallExpr.lower(new IdExpr("name")), Operator.Equals, FunctionCallExpr.lower(new VariableExpr("1")));
        BinaryExpr whereClause = new BinaryExpr(typeEpr, Operator.And, nameExpr);
        OneSelect oneSelect = new OneSelect(null, columns, from, whereClause, null);
        if (!"name".equals(column)) {
            return Select.from(oneSelect);
        }
        LiteralExpr masterExpr = LiteralExpr.string(sqlite_master);
        Expr masterClause = like ? LikeExpr.like(masterExpr, new VariableExpr("1")) : new BinaryExpr(masterExpr, Operator.Equals, FunctionCallExpr.lower(new VariableExpr("1")));
        CompoundSelect union = new CompoundSelect(CompoundOperator.Union, new OneSelect(null, Collections.singletonList(ResultColumn.expr(masterExpr, null)), null, masterClause, null));
        return Select.from(new SelectBody(oneSelect, Collections.singletonList(union)));
    }
}

