/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser;

import java.io.Reader;
import org.sqlite.parser.ErrorCode;
import org.sqlite.parser.Identifier;
import org.sqlite.parser.Keyword;
import org.sqlite.parser.ScanException;
import org.sqlite.parser.Scanner;

class Tokenizer
extends Scanner {
    private int lineno;
    private int column;
    private int nextColumn;
    private int nextLineno;
    private int tokenStart;
    private int tokenEnd;

    Tokenizer(Reader r) {
        super(r);
    }

    @Override
    void init(Reader r) {
        super.init(r);
        this.lineno = 1;
        this.column = 1;
        this.nextColumn = 1;
        this.nextLineno = 1;
        this.tokenStart = 0;
        this.tokenEnd = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    short split(char[] data, int start, int end, boolean atEOF) throws ScanException {
        if (atEOF && end == start) {
            return 0;
        }
        char c = data[start];
        this.tokenStart = start++;
        if (Character.isWhitespace(c)) {
            int i;
            for (i = start; i < end && Character.isWhitespace(data[i]); ++i) {
            }
            this.advance(i, data);
            return 0;
        }
        if (c == '-') {
            if (start < end) {
                if (data[start] == '-') {
                    int i;
                    for (i = start + 1; i < end && (c = data[i]) != '\n'; ++i) {
                    }
                    if (c != '\n') {
                        if (!atEOF) return 0;
                    }
                    this.advance(i + (atEOF ? 0 : 1), data);
                    return 0;
                }
                this.advance(start, data);
                return 90;
            }
            if (!atEOF) return 0;
            this.advance(start, data);
            return 90;
        }
        if (c == '(') {
            this.advance(start, data);
            return 22;
        }
        if (c == ')') {
            this.advance(start, data);
            return 23;
        }
        if (c == ';') {
            this.advance(start, data);
            return 1;
        }
        if (c == '+') {
            this.advance(start, data);
            return 89;
        }
        if (c == '*') {
            this.advance(start, data);
            return 91;
        }
        if (c == '/') {
            if (start < end) {
                if (data[start] == '*') {
                    int i;
                    for (i = start + 1; i < end && (c != '*' || data[i] != '/'); ++i) {
                        c = data[i];
                    }
                    if (i < end && data[i] == '/') {
                        this.advance(i + 1, data);
                        return 0;
                    }
                    if (!atEOF) return 0;
                    throw new ScanException(ErrorCode.UnterminatedBlockComment);
                }
                this.advance(start, data);
                return 92;
            }
            if (!atEOF) return 0;
            this.advance(start, data);
            return 92;
        }
        if (c == '%') {
            this.advance(start, data);
            return 93;
        }
        if (c == '=') {
            if (start < end) {
                if (data[start] == '=') {
                    this.advance(start + 1, data);
                    return 53;
                } else {
                    this.advance(start, data);
                }
                return 53;
            }
            if (!atEOF) return 0;
            this.advance(start, data);
            return 53;
        }
        if (c == '<') {
            if (start < end) {
                if (data[start] == '=') {
                    this.advance(start + 1, data);
                    return 55;
                }
                if (data[start] == '>') {
                    this.advance(start + 1, data);
                    return 52;
                }
                if (data[start] == '<') {
                    this.advance(start + 1, data);
                    return 87;
                }
                this.advance(start, data);
                return 56;
            }
            if (!atEOF) return 0;
            this.advance(start, data);
            return 56;
        }
        if (c == '>') {
            if (start < end) {
                if (data[start] == '=') {
                    this.advance(start + 1, data);
                    return 57;
                }
                if (data[start] == '>') {
                    this.advance(start + 1, data);
                    return 88;
                }
                this.advance(start, data);
                return 54;
            }
            if (!atEOF) return 0;
            this.advance(start, data);
            return 54;
        }
        if (c == '!') {
            if (start < end) {
                if (data[start] != '=') throw new ScanException(ErrorCode.ExpectedEqualsSign);
                this.advance(start + 1, data);
                return 52;
            }
            if (!atEOF) return 0;
            throw new ScanException(ErrorCode.ExpectedEqualsSign);
        }
        if (c == '|') {
            if (start < end) {
                if (data[start] == '|') {
                    this.advance(start + 1, data);
                    return 94;
                }
                this.advance(start, data);
                return 86;
            }
            if (!atEOF) return 0;
            this.advance(start, data);
            return 86;
        }
        if (c == ',') {
            this.advance(start, data);
            return 26;
        }
        if (c == '&') {
            this.advance(start, data);
            return 85;
        }
        if (c == '~') {
            this.advance(start, data);
            return 96;
        }
        if (c == '`' || c == '\'' || c == '\"') {
            int i;
            char pc = '\u0000';
            int escapedQuotes = 0;
            for (i = start; i < end; ++i) {
                if (data[i] == c) {
                    if (pc == c) {
                        pc = '\u0000';
                        ++escapedQuotes;
                        continue;
                    }
                } else if (pc == c) break;
                pc = data[i];
            }
            if (i < end || atEOF && pc == c) {
                this.advance(i, data);
                Tokenizer.unescapeQuotes(data, start, i - 1, c, escapedQuotes);
                this.tokenStart = start;
                this.tokenEnd = i - 1 - escapedQuotes;
                if (c != '\'') return 59;
                return 99;
            }
            if (!atEOF) return 0;
            throw new ScanException(ErrorCode.UnterminatedLiteral);
        }
        if (c == '.') {
            if (start < end) {
                if (Tokenizer.isDigit(data[start])) {
                    return this.fractionalPart(data, start, end, atEOF);
                }
                this.advance(start, data);
                return 123;
            }
            if (!atEOF) return 0;
            this.advance(start, data);
            return 123;
        }
        if (Tokenizer.isDigit(c)) {
            return this.number(data, start, end, atEOF);
        }
        if (c == '[') {
            int i;
            for (i = start; i < end && (c = data[i]) != ']'; ++i) {
            }
            if (c == ']') {
                this.advance(i + 1, data);
                this.tokenStart = start;
                this.tokenEnd = i;
                return 59;
            }
            if (!atEOF) return 0;
            throw new ScanException(ErrorCode.UnterminatedBracket);
        }
        if (c == '?') {
            int i;
            for (i = start; i < end && Tokenizer.isDigit(data[i]); ++i) {
            }
            if (i >= end) {
                if (!atEOF) return 0;
            }
            this.advance(i, data);
            this.tokenStart = start;
            return 137;
        }
        if (c == '$' || c == '@' || c == '#' || c == ':') {
            int i;
            for (i = start; i < end && Identifier.isIdentifierContinue(data[i]); ++i) {
            }
            if (i >= end) {
                if (!atEOF) return 0;
            }
            if (i == start) {
                throw new ScanException(ErrorCode.BadVariableName);
            }
            this.advance(i, data);
            return 137;
        }
        if (!Identifier.isIdentifierStart(c)) throw new ScanException(ErrorCode.UnrecognizedToken);
        if (c != 'x') {
            if (c != 'X') return this.identifierish(data, start, end, atEOF);
        }
        if (start < end) {
            if (data[start] != '\'') return this.identifierish(data, start, end, atEOF);
            return this.blobLiteral(data, start, end, atEOF);
        }
        if (!atEOF) return 0;
        this.advance(start, data);
        return 59;
    }

    private short number(char[] data, int start, int end, boolean atEOF) throws ScanException {
        int i;
        if (data[start - 1] == '0') {
            if (start < end) {
                if (data[start] == 'x' || data[start] == 'X') {
                    return this.hexInteger(data, start + 1, end, atEOF);
                }
            } else {
                if (atEOF) {
                    this.advance(start, data);
                    return 136;
                }
                return 0;
            }
        }
        for (i = start; i < end && Tokenizer.isDigit(data[i]); ++i) {
        }
        if (i < end) {
            if (data[i] == '.') {
                return this.fractionalPart(data, i + 1, end, atEOF);
            }
            if (data[i] == 'e' || data[i] == 'E') {
                return this.exponentialPart(data, i + 1, end, atEOF);
            }
            if (Identifier.isIdentifierStart(data[i])) {
                throw new ScanException(ErrorCode.BadNumber);
            }
            this.advance(i, data);
            return 136;
        }
        if (atEOF) {
            this.advance(i, data);
            return 136;
        }
        return 0;
    }

    private short hexInteger(char[] data, int start, int end, boolean atEOF) throws ScanException {
        int i;
        for (i = start; i < end && Tokenizer.isHexaDigit(data[i]); ++i) {
        }
        if (i < end) {
            if (i == start) {
                throw new ScanException(ErrorCode.MalformedHexInteger);
            }
            if (Identifier.isIdentifierStart(data[i])) {
                throw new ScanException(ErrorCode.MalformedHexInteger);
            }
            this.advance(i, data);
            return 136;
        }
        if (atEOF) {
            if (i == start) {
                throw new ScanException(ErrorCode.MalformedHexInteger);
            }
            this.advance(i, data);
            return 136;
        }
        return 0;
    }

    private short fractionalPart(char[] data, int start, int end, boolean atEOF) throws ScanException {
        int i;
        for (i = start; i < end && Tokenizer.isDigit(data[i]); ++i) {
        }
        if (i < end) {
            if (data[i] == 'e' || data[i] == 'E') {
                return this.exponentialPart(data, i + 1, end, atEOF);
            }
            if (Identifier.isIdentifierStart(data[i])) {
                throw new ScanException(ErrorCode.BadNumber);
            }
            this.advance(i, data);
            return 134;
        }
        if (atEOF) {
            this.advance(i, data);
            return 134;
        }
        return 0;
    }

    private short exponentialPart(char[] data, int start, int end, boolean atEOF) throws ScanException {
        if (start < end) {
            int i;
            if (data[start] == '+' || data[start] == '-') {
                ++start;
            }
            for (i = start; i < end && Tokenizer.isDigit(data[i]); ++i) {
            }
            if (i < end || atEOF) {
                if (i == start) {
                    throw new ScanException(ErrorCode.BadNumber);
                }
                if (Identifier.isIdentifierStart(data[i])) {
                    throw new ScanException(ErrorCode.BadNumber);
                }
                this.advance(i, data);
                return 134;
            }
        } else if (atEOF) {
            throw new ScanException(ErrorCode.BadNumber);
        }
        return 0;
    }

    private short blobLiteral(char[] data, int start, int end, boolean atEOF) throws ScanException {
        int i;
        int n = 0;
        for (i = start + 1; i < end && Tokenizer.isHexaDigit(data[i]); ++i) {
            ++n;
        }
        if (i < end) {
            if (data[i] != '\'' || n % 2 != 0) {
                throw new ScanException(ErrorCode.MalformedBlobLiteral);
            }
            this.advance(i + 1, data);
            this.tokenStart = start + 1;
            this.tokenEnd = i;
            return 135;
        }
        if (atEOF) {
            throw new ScanException(ErrorCode.MalformedBlobLiteral);
        }
        return 0;
    }

    private short identifierish(char[] data, int start, int end, boolean atEOF) throws ScanException {
        int i;
        for (i = start; i < end && Identifier.isIdentifierContinue(data[i]); ++i) {
        }
        if (i < end || atEOF) {
            this.advance(i, data);
            Short keyword = Keyword.tokenType(new String(data, start - 1, i - (start - 1)));
            if (keyword == null) {
                return 59;
            }
            return keyword;
        }
        return 0;
    }

    public String text() {
        return this.subSequence(this.tokenStart, this.tokenEnd);
    }

    int lineno() {
        return this.lineno;
    }

    int column() {
        return this.column;
    }

    private void advance(int n, char[] data) throws ScanException {
        super.advance(n);
        this.tokenEnd = n;
        this.lineno = this.nextLineno;
        this.column = this.nextColumn;
        for (int i = this.tokenStart; i < this.tokenEnd; ++i) {
            if (data[i] == '\n') {
                ++this.nextLineno;
                this.nextColumn = 1;
            }
            ++this.nextColumn;
        }
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHexaDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static void unescapeQuotes(char[] data, int start, int end, char quote, int count) {
        if (count == 0) {
            return;
        }
        int i = start;
        int j = start;
        while (i < end) {
            data[j] = data[i];
            if (data[i] == quote) {
                ++i;
            }
            ++i;
            ++j;
        }
    }
}

