/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.ast.ColumnDefinition;
import org.sqlite.parser.ast.QualifiedName;
import org.sqlite.parser.ast.Stmt;
import org.sqlite.parser.ast.ToSql;

public class AlterTable
implements Stmt {
    public final QualifiedName tblName;
    public final String renameTo;
    public final ColumnDefinition colDefinition;

    public AlterTable(QualifiedName tblName, String renameTo) {
        this.tblName = Objects.requireNonNull(tblName);
        this.renameTo = Objects.requireNonNull(renameTo);
        this.colDefinition = null;
    }

    public AlterTable(QualifiedName tblName, ColumnDefinition colDefinition) {
        this.tblName = Objects.requireNonNull(tblName);
        this.renameTo = null;
        this.colDefinition = Objects.requireNonNull(colDefinition);
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        a.append("ALTER TABLE ");
        this.tblName.toSql(a);
        if (this.renameTo != null) {
            a.append(" RENAME TO ");
            ToSql.doubleQuote(a, this.renameTo);
        } else {
            a.append(" ADD COLUMN ");
            this.colDefinition.toSql(a);
        }
    }
}

