/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.ToSql;
import org.sqlite.parser.ast.WhenThenPair;

public class CaseExpr
implements Expr {
    public final Expr base;
    public final List<WhenThenPair> whenThenPairs;
    public final Expr elseExpr;

    public CaseExpr(Expr base, List<WhenThenPair> whenThenPairs, Expr elseExpr) {
        this.base = base;
        this.whenThenPairs = ToSql.requireNotEmpty(whenThenPairs);
        this.elseExpr = elseExpr;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        a.append("CASE");
        if (this.base != null) {
            a.append(' ');
            this.base.toSql(a);
        }
        for (WhenThenPair whenThenPair : this.whenThenPairs) {
            a.append(' ');
            whenThenPair.toSql(a);
        }
        if (this.elseExpr != null) {
            a.append(" ELSE ");
            this.elseExpr.toSql(a);
        }
        a.append(" END");
    }
}

