/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sqlite.parser.ParseException;
import org.sqlite.parser.ast.ColumnConstraint;
import org.sqlite.parser.ast.ColumnNameAndType;
import org.sqlite.parser.ast.DefaultColumnConstraint;
import org.sqlite.parser.ast.LiteralExpr;
import org.sqlite.parser.ast.NotNullColumnConstraint;
import org.sqlite.parser.ast.PrimaryKeyColumnConstraint;
import org.sqlite.parser.ast.ToSql;

public class ColumnDefinition
implements ToSql {
    public final ColumnNameAndType nameAndType;
    public final List<ColumnConstraint> constraints;
    public final PrimaryKeyColumnConstraint primaryKeyColumnConstraint;

    public ColumnDefinition(ColumnNameAndType nameAndType, List<ColumnConstraint> constraints) {
        this.nameAndType = Objects.requireNonNull(nameAndType);
        this.constraints = ToSql.nullToEmpty(constraints);
        if (!this.constraints.isEmpty()) {
            PrimaryKeyColumnConstraint pk = null;
            for (ColumnConstraint constraint : constraints) {
                if (!(constraint instanceof PrimaryKeyColumnConstraint)) continue;
                if (pk != null) {
                    throw new ParseException("Multiple PRIMARY KEY constraints");
                }
                pk = (PrimaryKeyColumnConstraint)constraint;
            }
            this.primaryKeyColumnConstraint = pk;
        } else {
            this.primaryKeyColumnConstraint = null;
        }
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        this.nameAndType.toSql(a);
        for (ColumnConstraint constraint : this.constraints) {
            a.append(' ');
            constraint.toSql(a);
        }
    }

    public Optional<Integer> getNullable() {
        return this.constraints.stream().filter(NotNullColumnConstraint.class::isInstance).findAny().map(NotNullColumnConstraint.class::cast).map(NotNullColumnConstraint::getNullable);
    }

    public LiteralExpr getDefault() {
        return this.constraints.stream().filter(DefaultColumnConstraint.class::isInstance).findAny().map(DefaultColumnConstraint.class::cast).map(dcc -> LiteralExpr.string(dcc.expr.toSql())).orElse(LiteralExpr.NULL);
    }
}

