/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.LiteralExpr;
import org.sqlite.parser.ast.ToSql;
import org.sqlite.parser.ast.Type;

public class ColumnNameAndType
implements ToSql {
    public final String colName;
    public final Type colType;

    public ColumnNameAndType(String colName, Type colType) {
        this.colName = Objects.requireNonNull(colName);
        this.colType = colType;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        ToSql.doubleQuote(a, this.colName);
        if (this.colType != null) {
            a.append(' ');
            this.colType.toSql(a);
        }
    }

    public LiteralExpr getTypeExpr() {
        if (this.colType == null) {
            return LiteralExpr.EMPTY_STRING;
        }
        return LiteralExpr.string(this.colType.toSql());
    }

    public int getDataType() {
        if (this.colType == null) {
            return 1111;
        }
        return this.colType.getDataType();
    }

    public Expr getSize() {
        if (this.colType == null) {
            return LiteralExpr.NULL;
        }
        return this.colType.getSize();
    }

    public Expr getDecimalDigits() {
        if (this.colType == null) {
            return LiteralExpr.NULL;
        }
        return this.colType.getDecimalDigits();
    }
}

