/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;
import org.sqlite.parser.ParseException;
import org.sqlite.parser.ast.ColumnDefinition;
import org.sqlite.parser.ast.CreateTableBody;
import org.sqlite.parser.ast.PrimaryKeyConstraint;
import org.sqlite.parser.ast.PrimaryKeyTableConstraint;
import org.sqlite.parser.ast.ResolveType;
import org.sqlite.parser.ast.SortOrder;
import org.sqlite.parser.ast.TableConstraint;
import org.sqlite.parser.ast.ToSql;
import org.sqlite.parser.ast.Type;

public class ColumnsAndConstraints
implements CreateTableBody {
    public final List<ColumnDefinition> columns;
    public final List<TableConstraint> constraints;
    public final boolean without;
    public final PrimaryKeyConstraint primaryKeyConstraint;

    public ColumnsAndConstraints(List<ColumnDefinition> columns, List<TableConstraint> constraints, boolean without) {
        this.columns = ToSql.requireNotEmpty(columns);
        this.constraints = ToSql.nullToEmpty(constraints);
        this.without = without;
        PrimaryKeyConstraint pk = null;
        for (final ColumnDefinition column : columns) {
            if (column.primaryKeyColumnConstraint == null) continue;
            if (pk != null) {
                throw new ParseException("More than one primary key");
            }
            pk = new PrimaryKeyConstraint(){

                @Override
                public int getNumberOfColumns() {
                    return 1;
                }

                @Override
                public String getColumnName(int index) {
                    if (index != 0) {
                        throw new IndexOutOfBoundsException(String.format("Index: %d, Size: 1", index));
                    }
                    return column.nameAndType.colName;
                }

                @Override
                public String getPrimaryKeyName() {
                    return column.primaryKeyColumnConstraint.name;
                }

                @Override
                public boolean allMatch(BiFunction<String, SortOrder, Boolean> columnChecker) {
                    return columnChecker.apply(column.nameAndType.colName, column.primaryKeyColumnConstraint.order);
                }

                @Override
                public ResolveType getConflictClause() {
                    return column.primaryKeyColumnConstraint.conflictClause;
                }

                @Override
                public boolean isAutoIncrement() {
                    return column.primaryKeyColumnConstraint.autoIncrement;
                }
            };
        }
        for (TableConstraint constraint : this.constraints) {
            if (!(constraint instanceof PrimaryKeyTableConstraint)) continue;
            if (pk != null) {
                throw new ParseException("More than one primary key");
            }
            pk = (PrimaryKeyConstraint)((Object)constraint);
        }
        this.primaryKeyConstraint = pk;
        if (without && pk == null) {
            throw new ParseException("PRIMARY KEY missing");
        }
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        a.append('(');
        ToSql.comma(a, this.columns);
        if (ToSql.isNotEmpty(this.constraints)) {
            a.append(", ");
            ToSql.comma(a, this.constraints);
        }
        a.append(')');
        if (this.without) {
            a.append(" WITHOUT ROWID");
        }
    }

    public boolean isAutoIncrement(String columnName) {
        if (this.primaryKeyConstraint == null) {
            return false;
        }
        return this.primaryKeyConstraint.allMatch((pkColName, order) -> pkColName.equalsIgnoreCase(columnName)) && (this.primaryKeyConstraint.isAutoIncrement() || this.isAnAliasForRowId(columnName));
    }

    public boolean isGeneratedColumn(String columnName) {
        return this.isAnAliasForRowId(columnName);
    }

    public boolean isAnAliasForRowId(String columnName) {
        if (this.without || this.primaryKeyConstraint == null) {
            return false;
        }
        if (!this.primaryKeyConstraint.allMatch((pkColName, order) -> pkColName.equalsIgnoreCase(columnName) && order == null || SortOrder.Asc == order)) {
            return false;
        }
        Type colType = this.primaryKeyConstraint instanceof ColumnDefinition ? ((ColumnDefinition)((Object)this.primaryKeyConstraint)).nameAndType.colType : this.columns.stream().filter(c -> columnName.equalsIgnoreCase(c.nameAndType.colName)).map(c -> c.nameAndType.colType).findAny().orElseThrow(AssertionError::new);
        return colType != null && colType.name.equalsIgnoreCase("INTEGER") && colType.size == null;
    }
}

