/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import org.sqlite.parser.TokenType;
import org.sqlite.parser.ast.ToSql;

public enum CompoundOperator implements ToSql
{
    Union,
    UnionAll,
    Except,
    Intersect;


    public static CompoundOperator from(short tt) {
        if (116 == tt) {
            return Union;
        }
        if (118 == tt) {
            return Except;
        }
        if (119 == tt) {
            return Intersect;
        }
        throw new IllegalArgumentException(String.format("Unsupported Compound operator: %s", TokenType.toString(tt)));
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (Union == this) {
            a.append("UNION");
        } else if (UnionAll == this) {
            a.append("UNION ALL");
        } else if (Except == this) {
            a.append("EXCEPT");
        } else if (Intersect == this) {
            a.append("INTERSECT");
        }
    }
}

