/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ast.IndexedColumn;
import org.sqlite.parser.ast.QualifiedName;
import org.sqlite.parser.ast.Select;
import org.sqlite.parser.ast.Stmt;
import org.sqlite.parser.ast.ToSql;

public class CreateView
implements Stmt {
    public final boolean temporary;
    public final boolean ifNotExists;
    public final QualifiedName viewName;
    public final List<IndexedColumn> columns;
    public final Select select;

    public CreateView(boolean temporary, boolean ifNotExists, QualifiedName viewName, List<IndexedColumn> columns, Select select) {
        this.temporary = temporary;
        this.ifNotExists = ifNotExists;
        this.viewName = Objects.requireNonNull(viewName);
        this.columns = columns;
        this.select = Objects.requireNonNull(select);
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        a.append("CREATE ");
        if (this.temporary) {
            a.append("TEMP ");
        }
        a.append("VIEW ");
        if (this.ifNotExists) {
            a.append("IF NOT EXISTS ");
        }
        this.viewName.toSql(a);
        if (ToSql.isNotEmpty(this.columns)) {
            a.append(" (");
            ToSql.comma(a, this.columns);
            a.append(')');
        }
        a.append(" AS ");
        this.select.toSql(a);
    }
}

