/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.Indexed;
import org.sqlite.parser.ast.Limit;
import org.sqlite.parser.ast.QualifiedName;
import org.sqlite.parser.ast.SortedColumn;
import org.sqlite.parser.ast.Stmt;
import org.sqlite.parser.ast.ToSql;
import org.sqlite.parser.ast.With;

public class Delete
implements Stmt {
    public final With with;
    public final QualifiedName tblName;
    public final Indexed indexed;
    public final Expr whereClause;
    public final List<SortedColumn> orderBy;
    public final Limit limit;

    public Delete(With with, QualifiedName tblName, Indexed indexed, Expr whereClause, List<SortedColumn> orderBy, Limit limit) {
        this.with = with;
        this.tblName = Objects.requireNonNull(tblName);
        this.indexed = indexed;
        this.whereClause = whereClause;
        this.orderBy = orderBy;
        this.limit = limit;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (this.with != null) {
            this.with.toSql(a);
            a.append(' ');
        }
        a.append("DELETE FROM ");
        this.tblName.toSql(a);
        if (this.indexed != null) {
            a.append(' ');
            this.indexed.toSql(a);
        }
        if (this.whereClause != null) {
            a.append(" WHERE ");
            this.whereClause.toSql(a);
        }
        if (ToSql.isNotEmpty(this.orderBy)) {
            a.append(" ORDER BY ");
            ToSql.comma(a, this.orderBy);
        }
        if (this.limit != null) {
            a.append(' ');
            this.limit.toSql(a);
        }
    }
}

