/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.ToSql;

public class DoublyQualifiedExpr
implements Expr {
    public final String dbName;
    public final String tblName;
    public final String colName;

    public DoublyQualifiedExpr(String dbName, String tblName, String colName) {
        this.dbName = Objects.requireNonNull(dbName);
        this.tblName = Objects.requireNonNull(tblName);
        this.colName = Objects.requireNonNull(colName);
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        ToSql.doubleQuote(a, this.dbName);
        a.append('.');
        ToSql.doubleQuote(a, this.tblName);
        a.append('.');
        ToSql.doubleQuote(a, this.colName);
    }
}

