/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.ParseException;
import org.sqlite.parser.ast.ColumnConstraint;
import org.sqlite.parser.ast.DeferSubclause;
import org.sqlite.parser.ast.ForeignKeyClause;
import org.sqlite.parser.ast.ForeignKeyConstraint;
import org.sqlite.parser.ast.ToSql;

public class ForeignKeyColumnConstraint
extends ColumnConstraint
implements ForeignKeyConstraint {
    public final ForeignKeyClause clause;
    public DeferSubclause derefClause;

    public ForeignKeyColumnConstraint(String name, ForeignKeyClause clause, DeferSubclause derefClause) {
        super(name);
        this.clause = Objects.requireNonNull(clause);
        this.derefClause = derefClause;
        if (ToSql.isNotEmpty(clause.columns) && clause.columns.size() != 1) {
            throw new ParseException(String.format("Inconsistent FOREIGN KEY column constraint with %d reference(s)", clause.columns.size()));
        }
    }

    @Override
    public ForeignKeyClause getClause() {
        return this.clause;
    }

    @Override
    public DeferSubclause getDerefClause() {
        return this.derefClause;
    }

    public void setDerefClause(DeferSubclause derefClause) {
        this.derefClause = derefClause;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        this.constraintName(a);
        a.append("REFERENCES ");
        this.clause.toSql(a);
        if (this.derefClause != null) {
            a.append(' ');
            this.derefClause.toSql(a);
        }
    }
}

