/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ParseException;
import org.sqlite.parser.ast.DeferSubclause;
import org.sqlite.parser.ast.ForeignKeyClause;
import org.sqlite.parser.ast.ForeignKeyConstraint;
import org.sqlite.parser.ast.IndexedColumn;
import org.sqlite.parser.ast.TableConstraint;
import org.sqlite.parser.ast.ToSql;

public class ForeignKeyTableConstraint
extends TableConstraint
implements ForeignKeyConstraint {
    public final List<IndexedColumn> columns;
    public final ForeignKeyClause clause;
    public final DeferSubclause derefClause;

    public ForeignKeyTableConstraint(String name, List<IndexedColumn> columns, ForeignKeyClause clause, DeferSubclause derefClause) {
        super(name);
        this.columns = ToSql.requireNotEmpty(columns);
        this.clause = Objects.requireNonNull(clause);
        this.derefClause = derefClause;
        if (ToSql.isNotEmpty(clause.columns) && columns.size() != clause.columns.size()) {
            throw new ParseException(String.format("Inconsistent FOREIGN KEY table constraint with %d column(s) but %d reference(s)", columns.size(), clause.columns.size()));
        }
    }

    @Override
    public ForeignKeyClause getClause() {
        return this.clause;
    }

    @Override
    public DeferSubclause getDerefClause() {
        return this.derefClause;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        this.constraintName(a);
        a.append("FOREIGN KEY ");
        a.append('(');
        ToSql.comma(a, this.columns);
        a.append(')');
        a.append(" REFERENCES ");
        this.clause.toSql(a);
        if (this.derefClause != null) {
            a.append(' ');
            this.derefClause.toSql(a);
        }
    }
}

