/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.QualifiedName;
import org.sqlite.parser.ast.ToSql;

public class InTableExpr
implements Expr {
    public final Expr lhs;
    public final boolean not;
    public final QualifiedName rhs;
    public final List<Expr> args;

    public InTableExpr(Expr lhs, boolean not, QualifiedName rhs, List<Expr> args) {
        this.lhs = Objects.requireNonNull(lhs);
        this.not = not;
        this.rhs = Objects.requireNonNull(rhs);
        this.args = args;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        this.lhs.toSql(a);
        if (this.not) {
            a.append(" NOT");
        }
        a.append(" IN ");
        this.rhs.toSql(a);
        if (this.args != null) {
            a.append('(');
            ToSql.comma(a, this.args);
            a.append(')');
        }
    }
}

