/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.ast.SortOrder;
import org.sqlite.parser.ast.ToSql;

public class IndexedColumn
implements ToSql {
    public final String colName;
    public final String collationName;
    public final SortOrder order;

    public IndexedColumn(String colName, String collationName, SortOrder order) {
        this.colName = Objects.requireNonNull(colName);
        this.collationName = collationName;
        this.order = order;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        ToSql.doubleQuote(a, this.colName);
        if (this.collationName != null) {
            a.append(" COLLATE ");
            ToSql.doubleQuote(a, this.collationName);
        }
        if (this.order != null) {
            a.append(' ');
            this.order.toSql(a);
        }
    }
}

