/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ast.ResolveType;
import org.sqlite.parser.ast.Select;
import org.sqlite.parser.ast.ToSql;
import org.sqlite.parser.ast.TriggerCmd;
import org.sqlite.parser.ast.Upsert;

public class InsertTriggerCmd
implements TriggerCmd {
    public final ResolveType orConflict;
    public final String tblName;
    public final List<String> columns;
    public final Select select;
    public final Upsert upsert;

    public InsertTriggerCmd(ResolveType orConflict, String tblName, List<String> columns, Select select, Upsert upsert) {
        this.orConflict = orConflict;
        this.tblName = Objects.requireNonNull(tblName);
        this.columns = columns;
        this.select = Objects.requireNonNull(select);
        this.upsert = upsert;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (ResolveType.Replace == this.orConflict) {
            a.append("REPLACE");
        } else {
            a.append("INSERT");
            if (this.orConflict != null) {
                a.append(" OR ");
                this.orConflict.toSql(a);
            }
        }
        a.append(" INTO ");
        ToSql.doubleQuote(a, this.tblName);
        if (ToSql.isNotEmpty(this.columns)) {
            a.append(" (");
            ToSql.commaNames(a, this.columns);
            a.append(") ");
        }
        a.append(' ');
        this.select.toSql(a);
        if (this.upsert != null) {
            this.upsert.toSql(a);
        }
    }
}

