/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.ToSql;

public class JoinConstraint
implements ToSql {
    public final Expr on;
    public final List<String> colNames;

    public static JoinConstraint on(Expr expr) {
        return new JoinConstraint(Objects.requireNonNull(expr), null);
    }

    public static JoinConstraint from(Expr expr, List<String> colNames) {
        if (expr == null && colNames == null) {
            return null;
        }
        if (expr != null && colNames != null) {
            throw new IllegalArgumentException(String.format("ON and USING join constraints are exclusive. You can specify both: %s, %s", expr, colNames));
        }
        return new JoinConstraint(expr, colNames);
    }

    public static JoinConstraint using(List<String> colNames) {
        return new JoinConstraint(null, ToSql.requireNotEmpty(colNames));
    }

    private JoinConstraint(Expr on, List<String> colNames) {
        this.on = on;
        this.colNames = colNames;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (this.on != null) {
            a.append("ON ");
            this.on.toSql(a);
        } else {
            a.append("USING (");
            ToSql.commaNames(a, this.colNames);
            a.append(')');
        }
    }
}

