/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.NotLike;

public class LikeExpr
implements Expr {
    public final Expr lhs;
    public final NotLike op;
    public final Expr rhs;
    public final Expr escape;

    public static LikeExpr like(Expr lhs, Expr rhs) {
        return new LikeExpr(lhs, NotLike.LIKE, rhs, null);
    }

    public LikeExpr(Expr lhs, NotLike op, Expr rhs, Expr escape) {
        this.lhs = Objects.requireNonNull(lhs);
        this.op = Objects.requireNonNull(op);
        this.rhs = Objects.requireNonNull(rhs);
        this.escape = escape;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        this.lhs.toSql(a);
        a.append(' ');
        this.op.toSql(a);
        a.append(' ');
        this.rhs.toSql(a);
        if (this.escape != null) {
            a.append(" ESCAPE ");
            this.escape.toSql(a);
        }
    }
}

