/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import org.sqlite.parser.TokenType;
import org.sqlite.parser.ast.ToSql;

public enum Operator implements ToSql
{
    Add,
    And,
    BitwiseAnd,
    BitwiseOr,
    Concat,
    Equals,
    Divide,
    Greater,
    GreaterEquals,
    Is,
    IsNot,
    LeftShift,
    Less,
    LessEquals,
    Modulus,
    Multiply,
    NotEquals,
    Or,
    RightShift,
    Substract;


    public static Operator from(short tt) {
        if (89 == tt) {
            return Add;
        }
        if (44 == tt) {
            return And;
        }
        if (85 == tt) {
            return BitwiseAnd;
        }
        if (86 == tt) {
            return BitwiseOr;
        }
        if (94 == tt) {
            return Concat;
        }
        if (53 == tt) {
            return Equals;
        }
        if (92 == tt) {
            return Divide;
        }
        if (54 == tt) {
            return Greater;
        }
        if (57 == tt) {
            return GreaterEquals;
        }
        if (45 == tt) {
            return Is;
        }
        if (87 == tt) {
            return LeftShift;
        }
        if (56 == tt) {
            return Less;
        }
        if (55 == tt) {
            return LessEquals;
        }
        if (93 == tt) {
            return Modulus;
        }
        if (91 == tt) {
            return Multiply;
        }
        if (52 == tt) {
            return NotEquals;
        }
        if (43 == tt) {
            return Or;
        }
        if (88 == tt) {
            return RightShift;
        }
        if (90 == tt) {
            return Substract;
        }
        throw new IllegalArgumentException(String.format("Unsupported Operator: %s", TokenType.toString(tt)));
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (Add == this) {
            a.append("+");
        } else if (And == this) {
            a.append("AND");
        } else if (BitwiseAnd == this) {
            a.append("&");
        } else if (BitwiseOr == this) {
            a.append("|");
        } else if (Concat == this) {
            a.append("||");
        } else if (Equals == this) {
            a.append("=");
        } else if (Divide == this) {
            a.append("/");
        } else if (Greater == this) {
            a.append(">");
        } else if (GreaterEquals == this) {
            a.append(">=");
        } else if (Is == this) {
            a.append("IS");
        } else if (IsNot == this) {
            a.append("IS NOT");
        } else if (LeftShift == this) {
            a.append("<<");
        } else if (Less == this) {
            a.append("<");
        } else if (LessEquals == this) {
            a.append("<=");
        } else if (Modulus == this) {
            a.append("%");
        } else if (Multiply == this) {
            a.append("*");
        } else if (NotEquals == this) {
            a.append("<>");
        } else if (Or == this) {
            a.append("OR");
        } else if (RightShift == this) {
            a.append(">>");
        } else if (Substract == this) {
            a.append("-");
        }
    }
}

