/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import org.sqlite.parser.ast.ColumnConstraint;
import org.sqlite.parser.ast.ResolveType;
import org.sqlite.parser.ast.SortOrder;

public class PrimaryKeyColumnConstraint
extends ColumnConstraint {
    public final SortOrder order;
    public final ResolveType conflictClause;
    public final boolean autoIncrement;

    public PrimaryKeyColumnConstraint(String name, SortOrder order, ResolveType conflictClause, boolean autoIncrement) {
        super(name);
        this.order = order;
        this.conflictClause = conflictClause;
        this.autoIncrement = autoIncrement;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        this.constraintName(a);
        a.append("PRIMARY KEY");
        if (this.order != null) {
            a.append(' ');
            this.order.toSql(a);
        }
        if (this.conflictClause != null) {
            a.append(" ON CONFLICT ");
            this.conflictClause.toSql(a);
        }
        if (this.autoIncrement) {
            a.append(" AUTOINCREMENT");
        }
    }
}

