/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.IdExpr;
import org.sqlite.parser.ast.LiteralExpr;
import org.sqlite.parser.ast.LiteralType;
import org.sqlite.parser.ast.PrimaryKeyConstraint;
import org.sqlite.parser.ast.ResolveType;
import org.sqlite.parser.ast.SortOrder;
import org.sqlite.parser.ast.SortedColumn;
import org.sqlite.parser.ast.TableConstraint;
import org.sqlite.parser.ast.ToSql;

public class PrimaryKeyTableConstraint
extends TableConstraint
implements PrimaryKeyConstraint {
    public final List<SortedColumn> columns;
    public final boolean autoIncrement;
    public final ResolveType conflictClause;

    public PrimaryKeyTableConstraint(String name, List<SortedColumn> columns, boolean autoIncrement, ResolveType conflictClause) {
        super(name);
        this.columns = ToSql.requireNotEmpty(columns);
        for (SortedColumn column : columns) {
            PrimaryKeyTableConstraint.getName(column);
        }
        this.conflictClause = conflictClause;
        this.autoIncrement = autoIncrement;
    }

    @Override
    public int getNumberOfColumns() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int index) {
        return PrimaryKeyTableConstraint.getName(this.columns.get(index));
    }

    @Override
    public String getPrimaryKeyName() {
        return this.name;
    }

    @Override
    public boolean allMatch(BiFunction<String, SortOrder, Boolean> columnChecker) {
        return this.columns.stream().map(sc -> (Boolean)columnChecker.apply(PrimaryKeyTableConstraint.getName(sc), sc.order)).allMatch(Boolean.TRUE::equals);
    }

    @Override
    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    @Override
    public ResolveType getConflictClause() {
        return this.conflictClause;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        this.constraintName(a);
        a.append("PRIMARY KEY");
        a.append('(');
        ToSql.comma(a, this.columns);
        if (this.autoIncrement) {
            a.append(" AUTOINCREMENT");
        }
        a.append(')');
        if (this.conflictClause != null) {
            a.append(" ON CONFLICT ");
            this.conflictClause.toSql(a);
        }
    }

    private static String getName(SortedColumn sc) {
        Expr expr = sc.name;
        if (expr instanceof IdExpr) {
            return ((IdExpr)expr).name;
        }
        if (expr instanceof LiteralExpr) {
            LiteralExpr literalExpr = (LiteralExpr)expr;
            if (literalExpr.type == LiteralType.Keyword || literalExpr.type == LiteralType.String) {
                return literalExpr.value;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported column name: %s", expr));
    }
}

