/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.ResolveType;
import org.sqlite.parser.ast.ToSql;

public class RaiseExpr
implements Expr {
    public final ResolveType type;
    public final String err;

    public RaiseExpr(ResolveType type, String err) {
        this.type = Objects.requireNonNull(type);
        if (type == ResolveType.Replace) {
            throw new IllegalArgumentException("REPLACE cannot be used as a resolve type in a RAISE expression");
        }
        this.err = err;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        a.append("RAISE(");
        this.type.toSql(a);
        if (this.err != null) {
            a.append(", ");
            ToSql.singleQuote(a, this.err);
        }
        a.append(')');
    }
}

