/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ast.Limit;
import org.sqlite.parser.ast.OneSelect;
import org.sqlite.parser.ast.SelectBody;
import org.sqlite.parser.ast.SortedColumn;
import org.sqlite.parser.ast.Stmt;
import org.sqlite.parser.ast.ToSql;
import org.sqlite.parser.ast.TriggerCmd;
import org.sqlite.parser.ast.With;

public class Select
implements Stmt,
TriggerCmd {
    public final With with;
    public final SelectBody body;
    public final List<SortedColumn> orderBy;
    public final Limit limit;

    public static Select from(OneSelect oneSelect) {
        return Select.from(new SelectBody(oneSelect, null));
    }

    public static Select from(SelectBody body) {
        return new Select(null, body, null, null);
    }

    public Select(With with, SelectBody body, List<SortedColumn> orderBy, Limit limit) {
        this.with = with;
        this.body = Objects.requireNonNull(body);
        this.orderBy = orderBy;
        this.limit = limit;
        if (body.select.values != null && ToSql.isEmpty(body.compounds) && (ToSql.isNotEmpty(orderBy) || limit != null)) {
            throw new IllegalArgumentException("ORDER BY or LIMIT clauses cannot be used with VALUES");
        }
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        if (this.with != null) {
            this.with.toSql(a);
            a.append(' ');
        }
        this.body.toSql(a);
        if (ToSql.isNotEmpty(this.orderBy)) {
            a.append(" ORDER BY ");
            ToSql.comma(a, this.orderBy);
        }
        if (this.limit != null) {
            a.append(' ');
            this.limit.toSql(a);
        }
    }
}

