/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.LiteralExpr;
import org.sqlite.parser.ast.ToSql;
import org.sqlite.parser.ast.TypeSize;

public class Type
implements ToSql {
    public final String name;
    public final TypeSize size;

    public Type(String name, TypeSize size) {
        this.name = Objects.requireNonNull(name);
        this.size = size;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        ToSql.doubleQuote(a, this.name);
        if (this.size != null) {
            a.append('(');
            this.size.toSql(a);
            a.append(')');
        }
    }

    public int getDataType() {
        if (this.name.isEmpty()) {
            return 1111;
        }
        String declType = this.name.toUpperCase();
        if (declType.contains("INT")) {
            return 4;
        }
        if (declType.contains("TEXT") || declType.contains("CHAR") || declType.contains("CLOB")) {
            return 12;
        }
        if (declType.contains("BLOB")) {
            return 2004;
        }
        if (declType.contains("REAL") || declType.contains("FLOA") || declType.contains("DOUB")) {
            return 7;
        }
        return 2;
    }

    public Expr getSize() {
        if (this.size == null) {
            return LiteralExpr.NULL;
        }
        return this.size.getSize();
    }

    public Expr getDecimalDigits() {
        if (this.size == null) {
            return LiteralExpr.NULL;
        }
        return this.size.getDecimalDigits();
    }
}

