/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import org.sqlite.parser.ast.ResolveType;
import org.sqlite.parser.ast.SortedColumn;
import org.sqlite.parser.ast.TableConstraint;
import org.sqlite.parser.ast.ToSql;

public class UniqueTableConstraint
extends TableConstraint {
    public final List<SortedColumn> columns;
    public final ResolveType conflictClause;

    public UniqueTableConstraint(String name, List<SortedColumn> columns, ResolveType conflictClause) {
        super(name);
        this.columns = ToSql.requireNotEmpty(columns);
        this.conflictClause = conflictClause;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        this.constraintName(a);
        a.append("UNIQUE");
        a.append('(');
        ToSql.comma(a, this.columns);
        a.append(')');
        if (this.conflictClause != null) {
            a.append(" ON CONFLICT ");
            this.conflictClause.toSql(a);
        }
    }
}

