/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser;

import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sqlite.parser.Parser;
import org.sqlite.parser.SchemaProvider;
import org.sqlite.parser.ast.As;
import org.sqlite.parser.ast.CaseExpr;
import org.sqlite.parser.ast.Cmd;
import org.sqlite.parser.ast.ColumnConstraint;
import org.sqlite.parser.ast.ColumnDefinition;
import org.sqlite.parser.ast.ColumnsAndConstraints;
import org.sqlite.parser.ast.CompoundOperator;
import org.sqlite.parser.ast.CompoundSelect;
import org.sqlite.parser.ast.CreateTable;
import org.sqlite.parser.ast.CreateTableBody;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.ForeignKeyColumnConstraint;
import org.sqlite.parser.ast.ForeignKeyTableConstraint;
import org.sqlite.parser.ast.FromClause;
import org.sqlite.parser.ast.IdExpr;
import org.sqlite.parser.ast.IndexedColumn;
import org.sqlite.parser.ast.LikeExpr;
import org.sqlite.parser.ast.Limit;
import org.sqlite.parser.ast.LiteralExpr;
import org.sqlite.parser.ast.OneSelect;
import org.sqlite.parser.ast.PrimaryKeyConstraint;
import org.sqlite.parser.ast.QualifiedName;
import org.sqlite.parser.ast.ResultColumn;
import org.sqlite.parser.ast.Select;
import org.sqlite.parser.ast.SelectBody;
import org.sqlite.parser.ast.SortedColumn;
import org.sqlite.parser.ast.Stmt;
import org.sqlite.parser.ast.TableConstraint;
import org.sqlite.parser.ast.WhenThenPair;

public class EnhancedPragma {
    public static Select tableInfo(String dbName, String tableNamePattern, String columnNamePattern, SchemaProvider schemaProvider) throws SQLException {
        IdExpr colNullable = new IdExpr("colnullable");
        IdExpr columnName = new IdExpr("cn");
        List<ResultColumn> columns = Arrays.asList(ResultColumn.expr(LiteralExpr.NULL, As.as("TABLE_CAT")), ResultColumn.expr(new IdExpr("db"), As.as("TABLE_SCHEM")), ResultColumn.expr(new IdExpr("tbl"), As.as("TABLE_NAME")), ResultColumn.expr(columnName, As.as("COLUMN_NAME")), ResultColumn.expr(new IdExpr("ct"), As.as("DATA_TYPE")), ResultColumn.expr(new IdExpr("tn"), As.as("TYPE_NAME")), ResultColumn.expr(new IdExpr("cs"), As.as("COLUMN_SIZE")), ResultColumn.expr(LiteralExpr.NULL, As.as("BUFFER_LENGTH")), ResultColumn.expr(new IdExpr("decimalDigits"), As.as("DECIMAL_DIGITS")), ResultColumn.expr(LiteralExpr.integer(10), As.as("NUM_PREC_RADIX")), ResultColumn.expr(colNullable, As.as("NULLABLE")), ResultColumn.expr(LiteralExpr.NULL, As.as("REMARKS")), ResultColumn.expr(new IdExpr("cdflt"), As.as("COLUMN_DEF")), ResultColumn.expr(LiteralExpr.NULL, As.as("SQL_DATA_TYPE")), ResultColumn.expr(LiteralExpr.NULL, As.as("SQL_DATETIME_SUB")), ResultColumn.expr(LiteralExpr.integer(10), As.as("CHAR_OCTET_LENGTH")), ResultColumn.expr(new IdExpr("ordpos"), As.as("ORDINAL_POSITION")), ResultColumn.expr(new CaseExpr(colNullable, Arrays.asList(new WhenThenPair(LiteralExpr.integer(0), LiteralExpr.string("NO")), new WhenThenPair(LiteralExpr.integer(1), LiteralExpr.string("YES"))), LiteralExpr.EMPTY_STRING), As.as("IS_NULLABLE")), ResultColumn.expr(LiteralExpr.NULL, As.as("SCOPE_CATALOG")), ResultColumn.expr(LiteralExpr.NULL, As.as("SCOPE_SCHEMA")), ResultColumn.expr(LiteralExpr.NULL, As.as("SCOPE_TABLE")), ResultColumn.expr(LiteralExpr.NULL, As.as("SOURCE_DATA_TYPE")), ResultColumn.expr(new IdExpr("autoinc"), As.as("IS_AUTOINCREMENT")), ResultColumn.expr(new IdExpr("generated"), As.as("IS_GENERATEDCOLUMN")));
        List<QualifiedName> tbls = schemaProvider.findTables(dbName, tableNamePattern);
        OneSelect head = null;
        ArrayList<List<Expr>> tail = new ArrayList<List<Expr>>();
        for (QualifiedName tableName : tbls) {
            LiteralExpr db = LiteralExpr.string(tableName.dbName);
            LiteralExpr tbl = LiteralExpr.string(tableName.name);
            String sql = schemaProvider.getSchema(tableName.dbName, tableName.name);
            ColumnsAndConstraints columnsAndConstraints = EnhancedPragma.getColumnsAndConstraints(tableName.name, sql);
            for (int i = 0; i < columnsAndConstraints.columns.size(); ++i) {
                ColumnDefinition column = columnsAndConstraints.columns.get(i);
                String colName = column.nameAndType.colName;
                LiteralExpr colNameExpr = LiteralExpr.string(colName);
                boolean rowIdAlias = columnsAndConstraints.isGeneratedColumn(colName);
                LiteralExpr colType = LiteralExpr.integer(rowIdAlias ? -8 : column.nameAndType.getDataType());
                LiteralExpr declType = column.nameAndType.getTypeExpr();
                Expr colSize = column.nameAndType.getSize();
                Expr decimalDigits = column.nameAndType.getDecimalDigits();
                Integer nullable = column.getNullable().orElse(columnsAndConstraints.isAnAliasForRowId(colName) ? 0 : 1);
                LiteralExpr columnDefault = column.getDefault();
                LiteralExpr ordpos = LiteralExpr.integer(i + 1);
                LiteralExpr autoinc = LiteralExpr.string(columnsAndConstraints.isAutoIncrement(colName) ? "YES" : (rowIdAlias ? "" : "NO"));
                LiteralExpr generated = LiteralExpr.string(rowIdAlias ? "YES" : "NO");
                head = EnhancedPragma.appendCol(head, tail, db, tbl, colNameExpr, colType, declType, colSize, decimalDigits, nullable, columnDefault, ordpos, autoinc, generated);
            }
        }
        Limit limit = null;
        if (head == null) {
            head = EnhancedPragma.appendCol(head, tail, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL, 2, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL);
            limit = new Limit(LiteralExpr.integer(0), null);
        }
        List<CompoundSelect> compounds = tail.isEmpty() ? null : Collections.singletonList(new CompoundSelect(CompoundOperator.UnionAll, new OneSelect(tail)));
        SelectBody subBody = new SelectBody(head, compounds);
        Select subSelect = new Select(null, subBody, null, limit);
        FromClause from = FromClause.from(subSelect);
        LikeExpr whereClause = null;
        if (columnNamePattern != null) {
            whereClause = LikeExpr.like(columnName, LiteralExpr.string(columnNamePattern));
        }
        OneSelect oneSelect = new OneSelect(null, columns, from, whereClause, null, null);
        SelectBody body = new SelectBody(oneSelect, null);
        List<SortedColumn> orderBy = Arrays.asList(new SortedColumn(new IdExpr("TABLE_SCHEM"), null), new SortedColumn(new IdExpr("TABLE_NAME"), null), new SortedColumn(new IdExpr("ORDINAL_POSITION"), null));
        Select select = new Select(null, body, orderBy, null);
        return select;
    }

    private static OneSelect appendCol(OneSelect head, List<List<Expr>> tail, Expr db, Expr tbl, Expr colNameExpr, Expr colType, Expr declType, Expr colSize, Expr decimalDigits, Integer nullable, Expr columnDefault, Expr ordpos, Expr autoinc, Expr generated) {
        if (head == null) {
            head = new OneSelect(null, Arrays.asList(ResultColumn.expr(db, As.as("db")), ResultColumn.expr(tbl, As.as("tbl")), ResultColumn.expr(colNameExpr, As.as("cn")), ResultColumn.expr(colType, As.as("ct")), ResultColumn.expr(declType, As.as("tn")), ResultColumn.expr(colSize, As.as("cs")), ResultColumn.expr(decimalDigits, As.as("decimalDigits")), ResultColumn.expr(LiteralExpr.integer(nullable), As.as("colnullable")), ResultColumn.expr(columnDefault, As.as("cdflt")), ResultColumn.expr(ordpos, As.as("ordpos")), ResultColumn.expr(autoinc, As.as("autoinc")), ResultColumn.expr(generated, As.as("generated"))), null, null, null, null);
        } else {
            tail.add(Arrays.asList(db, tbl, colNameExpr, colType, declType, colSize, decimalDigits, LiteralExpr.integer(nullable), columnDefault, ordpos, autoinc, generated));
        }
        return head;
    }

    public static Select getPrimaryKeys(String dbName, String table, SchemaProvider schemaProvider) throws SQLException {
        dbName = schemaProvider.getDbName(dbName, table);
        String sql = schemaProvider.getSchema(dbName, table);
        Cmd cmd = Parser.parse(sql);
        assert (cmd != null);
        PrimaryKeyConstraint primaryKeyConstraint = null;
        if (cmd.stmt instanceof CreateTable) {
            CreateTable createTable = (CreateTable)cmd.stmt;
            assert (createTable.tblName.name.equalsIgnoreCase(table));
            CreateTableBody createTableBody = createTable.body;
            if (createTableBody instanceof ColumnsAndConstraints) {
                primaryKeyConstraint = ((ColumnsAndConstraints)createTableBody).primaryKeyConstraint;
            }
        }
        LiteralExpr db = LiteralExpr.string(dbName);
        LiteralExpr tbl = LiteralExpr.string(table);
        List<ResultColumn> columns = Arrays.asList(ResultColumn.expr(LiteralExpr.NULL, As.as("TABLE_CAT")), ResultColumn.expr(db, As.as("TABLE_SCHEM")), ResultColumn.expr(tbl, As.as("TABLE_NAME")), ResultColumn.expr(new IdExpr("cn"), As.as("COLUMN_NAME")), ResultColumn.expr(new IdExpr("seq"), As.as("KEY_SEQ")), ResultColumn.expr(new IdExpr("pkName"), As.as("PK_NAME")));
        OneSelect head = null;
        ArrayList<List<Expr>> tail = new ArrayList<List<Expr>>();
        if (primaryKeyConstraint != null) {
            for (int i = 0; i < primaryKeyConstraint.getNumberOfColumns(); ++i) {
                LiteralExpr cn = LiteralExpr.string(primaryKeyConstraint.getColumnName(i));
                LiteralExpr seq = LiteralExpr.integer(i + 1);
                LiteralExpr pkName = LiteralExpr.string(primaryKeyConstraint.getPrimaryKeyName());
                head = EnhancedPragma.appendPK(head, tail, cn, seq, pkName);
            }
        }
        Limit limit = null;
        if (head == null) {
            head = EnhancedPragma.appendPK(head, tail, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL);
            limit = new Limit(LiteralExpr.integer(0), null);
        }
        List<CompoundSelect> compounds = tail.isEmpty() ? null : Collections.singletonList(new CompoundSelect(CompoundOperator.UnionAll, new OneSelect(tail)));
        SelectBody subBody = new SelectBody(head, compounds);
        Select subSelect = new Select(null, subBody, null, limit);
        FromClause from = FromClause.from(subSelect);
        OneSelect oneSelect = new OneSelect(null, columns, from, null, null, null);
        SelectBody body = new SelectBody(oneSelect, null);
        List<SortedColumn> orderBy = Collections.singletonList(new SortedColumn(new IdExpr("COLUMN_NAME"), null));
        Select select = new Select(null, body, orderBy, null);
        return select;
    }

    private static OneSelect appendPK(OneSelect head, List<List<Expr>> tail, LiteralExpr cn, LiteralExpr seq, LiteralExpr pkName) {
        if (head == null) {
            head = new OneSelect(null, Arrays.asList(ResultColumn.expr(cn, As.as("cn")), ResultColumn.expr(seq, As.as("seq")), ResultColumn.expr(pkName, As.as("pkName"))), null, null, null, null);
        } else {
            tail.add(Arrays.asList(cn, seq, pkName));
        }
        return head;
    }

    public static Select getCrossReference(String parentDbName, String parentTable, String foreignDbName, String foreignTable, SchemaProvider schemaProvider) throws SQLException {
        return EnhancedPragma.foreign_key_list(parentDbName, parentTable, foreignDbName, foreignTable, schemaProvider, true);
    }

    public static Select getImportedKeys(String dbName, String tableName, SchemaProvider schemaProvider) throws SQLException {
        return EnhancedPragma.foreign_key_list(null, null, dbName, tableName, schemaProvider, false);
    }

    /*
     * WARNING - void declaration
     */
    private static Select foreign_key_list(String parentDbName, String parentTable, String foreignDbName, String foreignTable, SchemaProvider schemaProvider, boolean cross) throws SQLException {
        void var17_22;
        IndexedColumn pic;
        PrimaryKeyConstraint primaryKeyConstraint;
        LiteralExpr pt;
        LiteralExpr pdb;
        foreignDbName = schemaProvider.getDbName(foreignDbName, foreignTable);
        String sql = schemaProvider.getSchema(foreignDbName, foreignTable);
        Cmd cmd = Parser.parse(sql);
        assert (cmd != null);
        List<Object> foreignColumns = Collections.emptyList();
        List<Object> foreignConstraints = Collections.emptyList();
        if (cmd.stmt instanceof CreateTable) {
            CreateTable createTable = (CreateTable)cmd.stmt;
            assert (createTable.tblName.name.equalsIgnoreCase(foreignTable));
            CreateTableBody createTableBody = createTable.body;
            if (createTableBody instanceof ColumnsAndConstraints) {
                ColumnsAndConstraints columnsAndConstraints = (ColumnsAndConstraints)createTableBody;
                foreignColumns = columnsAndConstraints.columns;
                foreignConstraints = columnsAndConstraints.constraints;
            }
        }
        LiteralExpr fdb = LiteralExpr.string(foreignDbName);
        LiteralExpr tbl = LiteralExpr.string(foreignTable);
        List<ResultColumn> columns = Arrays.asList(ResultColumn.expr(LiteralExpr.NULL, As.as("PKTABLE_CAT")), ResultColumn.expr(new IdExpr("pdb"), As.as("PKTABLE_SCHEM")), ResultColumn.expr(new IdExpr("pt"), As.as("PKTABLE_NAME")), ResultColumn.expr(new IdExpr("pc"), As.as("PKCOLUMN_NAME")), ResultColumn.expr(LiteralExpr.NULL, As.as("FKTABLE_CAT")), ResultColumn.expr(fdb, As.as("FKTABLE_SCHEM")), ResultColumn.expr(tbl, As.as("FKTABLE_NAME")), ResultColumn.expr(new IdExpr("fc"), As.as("FKCOLUMN_NAME")), ResultColumn.expr(new IdExpr("seq"), As.as("KEY_SEQ")), ResultColumn.expr(new IdExpr("updateRule"), As.as("UPDATE_RULE")), ResultColumn.expr(new IdExpr("deleteRule"), As.as("DELETE_RULE")), ResultColumn.expr(new IdExpr("fkName"), As.as("FK_NAME")), ResultColumn.expr(new IdExpr("pkName"), As.as("PK_NAME")), ResultColumn.expr(new IdExpr("deferrability"), As.as("DEFERRABILITY")));
        OneSelect head = null;
        ArrayList<List<Expr>> tail = new ArrayList<List<Expr>>();
        int count = 0;
        for (ColumnDefinition columnDefinition : foreignColumns) {
            for (ColumnConstraint constraint : columnDefinition.constraints) {
                LiteralExpr pkName;
                LiteralExpr pc;
                if (!(constraint instanceof ForeignKeyColumnConstraint)) continue;
                ForeignKeyColumnConstraint fcc = (ForeignKeyColumnConstraint)constraint;
                String parentTableName = fcc.clause.tblName;
                String dbName = schemaProvider.getDbName(foreignDbName, parentTableName);
                if (cross && !EnhancedPragma.match(parentDbName, parentTable, dbName, parentTableName)) continue;
                ++count;
                pdb = LiteralExpr.string(dbName);
                pt = LiteralExpr.string(parentTableName);
                String colName = columnDefinition.nameAndType.colName;
                LiteralExpr fc = LiteralExpr.string(colName);
                LiteralExpr seq = LiteralExpr.integer(1);
                LiteralExpr updateRule = fcc.clause.getUpdateRule();
                LiteralExpr deleteRule = fcc.clause.getDeleteRule();
                LiteralExpr fkName = LiteralExpr.string(fcc.name == null ? EnhancedPragma.generateForeignKeyName(foreignTable, parentTableName, count) : fcc.name);
                ColumnsAndConstraints parentBody = EnhancedPragma.getColumnsAndConstraints(parentTableName, schemaProvider.getSchema(foreignDbName, parentTableName));
                LiteralExpr deferrability = LiteralExpr.integer(fcc.getDeferrability());
                List<IndexedColumn> pics = fcc.clause.columns;
                if (pics == null || pics.isEmpty()) {
                    primaryKeyConstraint = EnhancedPragma.getPrimaryKeyConstraint(parentBody, foreignTable, parentTableName, 1);
                    pc = LiteralExpr.string(primaryKeyConstraint.getColumnName(0));
                    pkName = LiteralExpr.string(primaryKeyConstraint.getPrimaryKeyName());
                } else {
                    assert (pics.size() == 1);
                    pic = pics.get(0);
                    pc = LiteralExpr.string(pic.colName);
                    pkName = LiteralExpr.NULL;
                }
                head = EnhancedPragma.appendFK(head, tail, pdb, pt, pc, fc, seq, updateRule, deleteRule, fkName, pkName, deferrability);
            }
        }
        for (TableConstraint tableConstraint : foreignConstraints) {
            if (!(tableConstraint instanceof ForeignKeyTableConstraint)) continue;
            ForeignKeyTableConstraint ftc = (ForeignKeyTableConstraint)tableConstraint;
            String parentTableName = ftc.clause.tblName;
            String dbName = schemaProvider.getDbName(foreignDbName, parentTableName);
            if (cross && !EnhancedPragma.match(parentDbName, parentTable, dbName, parentTableName)) continue;
            LiteralExpr updateRule = ftc.clause.getUpdateRule();
            LiteralExpr deleteRule = ftc.clause.getDeleteRule();
            pdb = LiteralExpr.string(dbName);
            pt = LiteralExpr.string(parentTableName);
            LiteralExpr fkName = LiteralExpr.string(ftc.name == null ? EnhancedPragma.generateForeignKeyName(foreignTable, parentTableName, ++count) : ftc.name);
            List<IndexedColumn> fics = ftc.columns;
            ColumnsAndConstraints parentBody = EnhancedPragma.getColumnsAndConstraints(parentTableName, schemaProvider.getSchema(foreignDbName, parentTableName));
            LiteralExpr deferrability = LiteralExpr.integer(ftc.getDeferrability());
            List<IndexedColumn> pics = ftc.clause.columns;
            for (int i = 0; i < fics.size(); ++i) {
                LiteralExpr pkName;
                LiteralExpr pc;
                IndexedColumn fic = fics.get(i);
                LiteralExpr fc = LiteralExpr.string(fic.colName);
                LiteralExpr seq = LiteralExpr.integer(i + 1);
                if (pics == null || pics.isEmpty()) {
                    primaryKeyConstraint = EnhancedPragma.getPrimaryKeyConstraint(parentBody, foreignTable, parentTableName, fics.size());
                    pc = LiteralExpr.string(primaryKeyConstraint.getColumnName(i));
                    pkName = LiteralExpr.string(primaryKeyConstraint.getPrimaryKeyName());
                } else {
                    pic = pics.get(i);
                    pc = LiteralExpr.string(pic.colName);
                    pkName = LiteralExpr.NULL;
                }
                head = EnhancedPragma.appendFK(head, tail, pdb, pt, pc, fc, seq, updateRule, deleteRule, fkName, pkName, deferrability);
            }
        }
        Limit limit = null;
        if (head == null) {
            head = EnhancedPragma.appendFK(head, tail, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL, LiteralExpr.NULL);
            limit = new Limit(LiteralExpr.integer(0), null);
        }
        if (tail.isEmpty()) {
            Object var17_20 = null;
        } else {
            List<CompoundSelect> list = Collections.singletonList(new CompoundSelect(CompoundOperator.UnionAll, new OneSelect(tail)));
        }
        SelectBody subBody = new SelectBody(head, (List<CompoundSelect>)var17_22);
        Select subSelect = new Select(null, subBody, null, limit);
        FromClause from = FromClause.from(subSelect);
        OneSelect oneSelect = new OneSelect(null, columns, from, null, null, null);
        SelectBody body = new SelectBody(oneSelect, null);
        List<SortedColumn> orderBy = cross ? Arrays.asList(new SortedColumn(new IdExpr("FKTABLE_CAT"), null), new SortedColumn(new IdExpr("FKTABLE_SCHEM"), null), new SortedColumn(new IdExpr("FKTABLE_NAME"), null), new SortedColumn(new IdExpr("KEY_SEQ"), null)) : Arrays.asList(new SortedColumn(new IdExpr("PKTABLE_CAT"), null), new SortedColumn(new IdExpr("PKTABLE_SCHEM"), null), new SortedColumn(new IdExpr("PKTABLE_NAME"), null), new SortedColumn(new IdExpr("KEY_SEQ"), null));
        Select select = new Select(null, body, orderBy, null);
        return select;
    }

    private static boolean match(String parentDbName, String parentTable, String dbName, String parentTableName) {
        return parentTableName.equalsIgnoreCase(parentTable) && (parentDbName == null || parentDbName.equalsIgnoreCase(dbName));
    }

    private static String generateForeignKeyName(String tableName, String parentTableName, int count) {
        return tableName + '_' + parentTableName + '_' + count;
    }

    private static PrimaryKeyConstraint getPrimaryKeyConstraint(ColumnsAndConstraints parentBody, String tableName, String parentTableName, int expectedNumberOfColumns) throws SQLSyntaxErrorException {
        if (parentBody.primaryKeyConstraint == null) {
            throw new SQLSyntaxErrorException(String.format("No PRIMARY KEY declared in %s referenced by %s", parentTableName, tableName));
        }
        PrimaryKeyConstraint primaryKeyConstraint = parentBody.primaryKeyConstraint;
        if (primaryKeyConstraint.getNumberOfColumns() != expectedNumberOfColumns) {
            throw new SQLSyntaxErrorException(String.format("number of columns in foreign key of %s does not match the number of columns in the referenced table %s", parentTableName, tableName));
        }
        return primaryKeyConstraint;
    }

    private static OneSelect appendFK(OneSelect head, List<List<Expr>> tail, LiteralExpr pdb, LiteralExpr pt, LiteralExpr pc, LiteralExpr fc, LiteralExpr seq, LiteralExpr updateRule, LiteralExpr deleteRule, LiteralExpr fkName, LiteralExpr pkName, LiteralExpr deferrability) {
        if (head == null) {
            head = new OneSelect(null, Arrays.asList(ResultColumn.expr(pdb, As.as("pdb")), ResultColumn.expr(pt, As.as("pt")), ResultColumn.expr(pc, As.as("pc")), ResultColumn.expr(fc, As.as("fc")), ResultColumn.expr(seq, As.as("seq")), ResultColumn.expr(updateRule, As.as("updateRule")), ResultColumn.expr(deleteRule, As.as("deleteRule")), ResultColumn.expr(fkName, As.as("fkName")), ResultColumn.expr(pkName, As.as("pkName")), ResultColumn.expr(deferrability, As.as("deferrability"))), null, null, null, null);
        } else {
            tail.add(Arrays.asList(pdb, pt, pc, fc, seq, updateRule, deleteRule, fkName, pkName, deferrability));
        }
        return head;
    }

    private static ColumnsAndConstraints getColumnsAndConstraints(String tableName, String sql) throws SQLSyntaxErrorException {
        Cmd cmd = Parser.parse(sql);
        assert (cmd != null);
        Stmt stmt = cmd.stmt;
        assert (stmt instanceof CreateTable);
        CreateTable createTable = (CreateTable)stmt;
        assert (createTable.tblName.name.equalsIgnoreCase(tableName));
        CreateTableBody createTableBody = createTable.body;
        assert (createTableBody instanceof ColumnsAndConstraints);
        return (ColumnsAndConstraints)createTableBody;
    }
}

