/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import org.sqlite.parser.ErrorCode;
import org.sqlite.parser.ScanException;

abstract class Scanner {
    private Reader r;
    private final int maxTokenSize;
    private short tokenType;
    private char[] buf;
    private int start;
    private int end;
    private boolean eof;

    Scanner(Reader r) {
        this.init(r);
        this.maxTokenSize = 65536;
        this.buf = new char[4096];
    }

    void init(Reader r) {
        this.r = Objects.requireNonNull(r, "null reader");
        this.tokenType = 0;
        this.start = 0;
        this.end = 0;
        this.eof = false;
    }

    abstract short split(char[] var1, int var2, int var3, boolean var4) throws ScanException;

    boolean scan() throws ScanException {
        while (true) {
            if (this.end > this.start || this.eof) {
                int pstart = this.start;
                this.tokenType = this.split(this.buf, this.start, this.end, this.eof);
                if (this.tokenType != 0) {
                    return true;
                }
                if (pstart != this.start) continue;
            }
            if (this.eof) {
                this.start = 0;
                this.end = 0;
                return false;
            }
            this.read();
        }
    }

    public short tokenType() {
        return this.tokenType;
    }

    private void read() throws ScanException {
        if (this.start > 0 && (this.end == this.buf.length || this.start > this.buf.length / 2)) {
            System.arraycopy(this.buf, this.start, this.buf, 0, this.end - this.start);
            this.end -= this.start;
            this.start = 0;
        }
        if (this.end == this.buf.length) {
            if (this.buf.length >= this.maxTokenSize || this.buf.length > 0x3FFFFFFF) {
                throw new ScanException(ErrorCode.TokenTooLong);
            }
            int newSize = Math.min(this.buf.length * 2, this.maxTokenSize);
            char[] newBuf = new char[newSize];
            System.arraycopy(this.buf, this.start, newBuf, 0, this.end - this.start);
            this.buf = newBuf;
            this.end -= this.start;
            this.start = 0;
        }
        try {
            int n = this.r.read(this.buf, this.end, this.buf.length - this.end);
            if (n < 0) {
                this.eof = true;
            } else {
                this.end += n;
            }
        }
        catch (IOException e) {
            throw new ScanException(e.getMessage(), e);
        }
    }

    boolean atEndOfFile() {
        return this.eof;
    }

    String subSequence(int start, int end) {
        if (start < 0 || end < 0 || start > end || end > this.end) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return "";
        }
        return new String(this.buf, start, end - start);
    }

    void advance(int n) throws ScanException {
        if (n < 0) {
            throw new ScanException("SplitFunc returns negative advance count");
        }
        if (n > this.end) {
            throw new ScanException("SplitFunc returns advance count beyond input");
        }
        this.start = n;
    }
}

