/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser;

import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Queue;
import org.sqlite.parser.ErrorCode;
import org.sqlite.parser.Identifier;
import org.sqlite.parser.Keyword;
import org.sqlite.parser.ScanException;
import org.sqlite.parser.Scanner;
import org.sqlite.parser.Token;
import org.sqlite.parser.yyParser;

class Tokenizer
extends Scanner {
    private int lineno;
    private int column;
    private int nextColumn;
    private int nextLineno;
    private int tokenStart;
    private int tokenEnd;
    private final Queue<Token> lookahead = new ArrayDeque<Token>();

    Tokenizer(Reader r) {
        super(r);
    }

    @Override
    void init(Reader r) {
        super.init(r);
        this.lineno = 1;
        this.column = 1;
        this.nextColumn = 1;
        this.nextLineno = 1;
        this.tokenStart = 0;
        this.tokenEnd = 0;
        if (this.lookahead != null) {
            this.lookahead.clear();
        }
    }

    @Override
    boolean scan() throws ScanException {
        return !this.lookahead.isEmpty() || super.scan();
    }

    Token poll() {
        return this.lookahead.poll();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    short split(char[] data, int start, int end, boolean atEOF) throws ScanException {
        if (atEOF && end == start) {
            return 0;
        }
        char c = data[start];
        this.tokenStart = start++;
        if (Character.isWhitespace(c)) {
            int i;
            for (i = start; i < end && Character.isWhitespace(data[i]); ++i) {
            }
            this.advance(i, data);
            return 0;
        }
        if (c == '-') {
            if (start < end) {
                if (data[start] == '-') {
                    int i;
                    for (i = start + 1; i < end && (c = data[i]) != '\n'; ++i) {
                    }
                    if (c != '\n') {
                        if (!atEOF) return 0;
                    }
                    this.advance(i + (atEOF ? 0 : 1), data);
                    return 0;
                }
                this.advance(start, data);
                return 97;
            }
            if (!atEOF) return 0;
            this.advance(start, data);
            return 97;
        }
        if (c == '(') {
            this.advance(start, data);
            return 22;
        }
        if (c == ')') {
            this.advance(start, data);
            return 23;
        }
        if (c == ';') {
            this.advance(start, data);
            return 1;
        }
        if (c == '+') {
            this.advance(start, data);
            return 96;
        }
        if (c == '*') {
            this.advance(start, data);
            return 98;
        }
        if (c == '/') {
            if (start < end) {
                if (data[start] == '*') {
                    int i;
                    for (i = start + 1; i < end && (c != '*' || data[i] != '/'); ++i) {
                        c = data[i];
                    }
                    if (i < end && data[i] == '/') {
                        this.advance(i + 1, data);
                        return 0;
                    }
                    if (!atEOF) return 0;
                    throw new ScanException(ErrorCode.UnterminatedBlockComment);
                }
                this.advance(start, data);
                return 99;
            }
            if (!atEOF) return 0;
            this.advance(start, data);
            return 99;
        }
        if (c == '%') {
            this.advance(start, data);
            return 100;
        }
        if (c == '=') {
            if (start < end) {
                if (data[start] == '=') {
                    this.advance(start + 1, data);
                    return 53;
                } else {
                    this.advance(start, data);
                }
                return 53;
            }
            if (!atEOF) return 0;
            this.advance(start, data);
            return 53;
        }
        if (c == '<') {
            if (start < end) {
                if (data[start] == '=') {
                    this.advance(start + 1, data);
                    return 55;
                }
                if (data[start] == '>') {
                    this.advance(start + 1, data);
                    return 52;
                }
                if (data[start] == '<') {
                    this.advance(start + 1, data);
                    return 94;
                }
                this.advance(start, data);
                return 56;
            }
            if (!atEOF) return 0;
            this.advance(start, data);
            return 56;
        }
        if (c == '>') {
            if (start < end) {
                if (data[start] == '=') {
                    this.advance(start + 1, data);
                    return 57;
                }
                if (data[start] == '>') {
                    this.advance(start + 1, data);
                    return 95;
                }
                this.advance(start, data);
                return 54;
            }
            if (!atEOF) return 0;
            this.advance(start, data);
            return 54;
        }
        if (c == '!') {
            if (start < end) {
                if (data[start] != '=') throw new ScanException(ErrorCode.ExpectedEqualsSign);
                this.advance(start + 1, data);
                return 52;
            }
            if (!atEOF) return 0;
            throw new ScanException(ErrorCode.ExpectedEqualsSign);
        }
        if (c == '|') {
            if (start < end) {
                if (data[start] == '|') {
                    this.advance(start + 1, data);
                    return 101;
                }
                this.advance(start, data);
                return 93;
            }
            if (!atEOF) return 0;
            this.advance(start, data);
            return 93;
        }
        if (c == ',') {
            this.advance(start, data);
            return 26;
        }
        if (c == '&') {
            this.advance(start, data);
            return 92;
        }
        if (c == '~') {
            this.advance(start, data);
            return 103;
        }
        if (c == '`' || c == '\'' || c == '\"') {
            int i;
            char pc = '\u0000';
            int escapedQuotes = 0;
            for (i = start; i < end; ++i) {
                if (data[i] == c) {
                    if (pc == c) {
                        pc = '\u0000';
                        ++escapedQuotes;
                        continue;
                    }
                } else if (pc == c) break;
                pc = data[i];
            }
            if (i < end || atEOF && pc == c) {
                this.advance(i, data);
                Tokenizer.unescapeQuotes(data, start, i - 1, c, escapedQuotes);
                this.tokenStart = start;
                this.tokenEnd = i - 1 - escapedQuotes;
                if (c != '\'') return 59;
                return 106;
            }
            if (!atEOF) return 0;
            throw new ScanException(ErrorCode.UnterminatedLiteral);
        }
        if (c == '.') {
            if (start < end) {
                if (Tokenizer.isDigit(data[start])) {
                    return this.fractionalPart(data, start, end, atEOF);
                }
                this.advance(start, data);
                return 130;
            }
            if (!atEOF) return 0;
            this.advance(start, data);
            return 130;
        }
        if (Tokenizer.isDigit(c)) {
            return this.number(data, start, end, atEOF);
        }
        if (c == '[') {
            int i;
            for (i = start; i < end && (c = data[i]) != ']'; ++i) {
            }
            if (c == ']') {
                this.advance(i + 1, data);
                this.tokenStart = start;
                this.tokenEnd = i;
                return 59;
            }
            if (!atEOF) return 0;
            throw new ScanException(ErrorCode.UnterminatedBracket);
        }
        if (c == '?') {
            int i;
            for (i = start; i < end && Tokenizer.isDigit(data[i]); ++i) {
            }
            if (i >= end) {
                if (!atEOF) return 0;
            }
            this.advance(i, data);
            this.tokenStart = start;
            return 144;
        }
        if (c == '$' || c == '@' || c == '#' || c == ':') {
            int i;
            for (i = start; i < end && Identifier.isIdentifierContinue(data[i]); ++i) {
            }
            if (i >= end) {
                if (!atEOF) return 0;
            }
            if (i == start) {
                throw new ScanException(ErrorCode.BadVariableName);
            }
            this.advance(i, data);
            return 144;
        }
        if (!Identifier.isIdentifierStart(c)) throw new ScanException(ErrorCode.UnrecognizedToken);
        if (c != 'x') {
            if (c != 'X') return this.identifierish(data, start, end, atEOF);
        }
        if (start < end) {
            if (data[start] != '\'') return this.identifierish(data, start, end, atEOF);
            return this.blobLiteral(data, start, end, atEOF);
        }
        if (!atEOF) return 0;
        this.advance(start, data);
        return 59;
    }

    private short getToken() {
        if (!super.scan()) {
            return 0;
        }
        short t = this.tokenType();
        this.lookahead.add(new Token(t, this.text()));
        if (t == 59 || t == 106 || t == 107 || t == 152 || t == 153 || yyParser.sqlite3ParserFallback(t) == 59) {
            t = 59;
        }
        return t;
    }

    short analyzeWindowKeyword() {
        short t = this.getToken();
        if (t != 59) {
            return 59;
        }
        t = this.getToken();
        if (t != 24) {
            return 59;
        }
        return 152;
    }

    short analyzeOverKeyword(short lastToken) {
        short t;
        if (lastToken == 23 && ((t = this.getToken()) == 22 || t == 59)) {
            return 153;
        }
        return 59;
    }

    short analyzeFilterKeyword(short lastToken) {
        if (lastToken == 23 && this.getToken() == 22) {
            return 154;
        }
        return 59;
    }

    private short number(char[] data, int start, int end, boolean atEOF) throws ScanException {
        int i;
        if (data[start - 1] == '0') {
            if (start < end) {
                if (data[start] == 'x' || data[start] == 'X') {
                    return this.hexInteger(data, start + 1, end, atEOF);
                }
            } else {
                if (atEOF) {
                    this.advance(start, data);
                    return 143;
                }
                return 0;
            }
        }
        for (i = start; i < end && Tokenizer.isDigit(data[i]); ++i) {
        }
        if (i < end) {
            if (data[i] == '.') {
                return this.fractionalPart(data, i + 1, end, atEOF);
            }
            if (data[i] == 'e' || data[i] == 'E') {
                return this.exponentialPart(data, i + 1, end, atEOF);
            }
            if (Identifier.isIdentifierStart(data[i])) {
                throw new ScanException(ErrorCode.BadNumber);
            }
            this.advance(i, data);
            return 143;
        }
        if (atEOF) {
            this.advance(i, data);
            return 143;
        }
        return 0;
    }

    private short hexInteger(char[] data, int start, int end, boolean atEOF) throws ScanException {
        int i;
        for (i = start; i < end && Tokenizer.isHexaDigit(data[i]); ++i) {
        }
        if (i < end) {
            if (i == start) {
                throw new ScanException(ErrorCode.MalformedHexInteger);
            }
            if (Identifier.isIdentifierStart(data[i])) {
                throw new ScanException(ErrorCode.MalformedHexInteger);
            }
            this.advance(i, data);
            return 143;
        }
        if (atEOF) {
            if (i == start) {
                throw new ScanException(ErrorCode.MalformedHexInteger);
            }
            this.advance(i, data);
            return 143;
        }
        return 0;
    }

    private short fractionalPart(char[] data, int start, int end, boolean atEOF) throws ScanException {
        int i;
        for (i = start; i < end && Tokenizer.isDigit(data[i]); ++i) {
        }
        if (i < end) {
            if (data[i] == 'e' || data[i] == 'E') {
                return this.exponentialPart(data, i + 1, end, atEOF);
            }
            if (Identifier.isIdentifierStart(data[i])) {
                throw new ScanException(ErrorCode.BadNumber);
            }
            this.advance(i, data);
            return 141;
        }
        if (atEOF) {
            this.advance(i, data);
            return 141;
        }
        return 0;
    }

    private short exponentialPart(char[] data, int start, int end, boolean atEOF) throws ScanException {
        if (start < end) {
            int i;
            if (data[start] == '+' || data[start] == '-') {
                ++start;
            }
            for (i = start; i < end && Tokenizer.isDigit(data[i]); ++i) {
            }
            if (i < end || atEOF) {
                if (i == start) {
                    throw new ScanException(ErrorCode.BadNumber);
                }
                if (Identifier.isIdentifierStart(data[i])) {
                    throw new ScanException(ErrorCode.BadNumber);
                }
                this.advance(i, data);
                return 141;
            }
        } else if (atEOF) {
            throw new ScanException(ErrorCode.BadNumber);
        }
        return 0;
    }

    private short blobLiteral(char[] data, int start, int end, boolean atEOF) throws ScanException {
        int i;
        int n = 0;
        for (i = start + 1; i < end && Tokenizer.isHexaDigit(data[i]); ++i) {
            ++n;
        }
        if (i < end) {
            if (data[i] != '\'' || n % 2 != 0) {
                throw new ScanException(ErrorCode.MalformedBlobLiteral);
            }
            this.advance(i + 1, data);
            this.tokenStart = start + 1;
            this.tokenEnd = i;
            return 142;
        }
        if (atEOF) {
            throw new ScanException(ErrorCode.MalformedBlobLiteral);
        }
        return 0;
    }

    private short identifierish(char[] data, int start, int end, boolean atEOF) throws ScanException {
        int i;
        for (i = start; i < end && Identifier.isIdentifierContinue(data[i]); ++i) {
        }
        if (i < end || atEOF) {
            this.advance(i, data);
            Short keyword = Keyword.tokenType(new String(data, start - 1, i - (start - 1)));
            if (keyword == null) {
                return 59;
            }
            return keyword;
        }
        return 0;
    }

    public String text() {
        return this.subSequence(this.tokenStart, this.tokenEnd);
    }

    int lineno() {
        return this.lineno;
    }

    int column() {
        return this.column;
    }

    private void advance(int n, char[] data) throws ScanException {
        super.advance(n);
        this.tokenEnd = n;
        this.lineno = this.nextLineno;
        this.column = this.nextColumn;
        for (int i = this.tokenStart; i < this.tokenEnd; ++i) {
            if (data[i] == '\n') {
                ++this.nextLineno;
                this.nextColumn = 1;
            }
            ++this.nextColumn;
        }
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHexaDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static void unescapeQuotes(char[] data, int start, int end, char quote, int count) {
        if (count == 0) {
            return;
        }
        int i = start;
        int j = start;
        while (i < end) {
            data[j] = data[i];
            if (data[i] == quote) {
                ++i;
            }
            ++i;
            ++j;
        }
    }
}

