/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.ast.ColumnDefinition;
import org.sqlite.parser.ast.QualifiedName;
import org.sqlite.parser.ast.RenameColumn;
import org.sqlite.parser.ast.Stmt;
import org.sqlite.parser.ast.ToSql;

public class AlterTable
implements Stmt {
    public final QualifiedName tblName;
    public final String renameTo;
    public final ColumnDefinition colDefinition;
    public final RenameColumn renameColumn;

    public AlterTable(QualifiedName tblName, String renameTo) {
        this.tblName = Objects.requireNonNull(tblName);
        this.renameTo = Objects.requireNonNull(renameTo);
        this.colDefinition = null;
        this.renameColumn = null;
    }

    public AlterTable(QualifiedName tblName, ColumnDefinition colDefinition) {
        this.tblName = Objects.requireNonNull(tblName);
        this.renameTo = null;
        this.colDefinition = Objects.requireNonNull(colDefinition);
        this.renameColumn = null;
    }

    public AlterTable(QualifiedName tblName, RenameColumn renameColumn) {
        this.tblName = Objects.requireNonNull(tblName);
        this.renameTo = null;
        this.colDefinition = null;
        this.renameColumn = Objects.requireNonNull(renameColumn);
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        a.append("ALTER TABLE ");
        this.tblName.toSql(a);
        a.append(' ');
        if (this.renameTo != null) {
            a.append("RENAME TO ");
            ToSql.doubleQuote(a, this.renameTo);
        } else if (this.colDefinition != null) {
            a.append("ADD COLUMN ");
            this.colDefinition.toSql(a);
        } else {
            this.renameColumn.toSql(a);
        }
    }
}

