/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ast.IndexedColumn;
import org.sqlite.parser.ast.Select;
import org.sqlite.parser.ast.ToSql;

public class CommonTableExpr
implements ToSql {
    public final String tblName;
    public final List<IndexedColumn> columns;
    public final Select select;

    public CommonTableExpr(String tblName, List<IndexedColumn> columns, Select select) {
        this.tblName = Objects.requireNonNull(tblName);
        this.columns = columns;
        this.select = Objects.requireNonNull(select);
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        ToSql.doubleQuote(a, this.tblName);
        if (ToSql.isNotEmpty(this.columns)) {
            a.append(" (");
            ToSql.comma(a, this.columns);
            a.append(')');
        }
        a.append(" AS (");
        this.select.toSql(a);
        a.append(')');
    }
}

