/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.QualifiedName;
import org.sqlite.parser.ast.SortedColumn;
import org.sqlite.parser.ast.Stmt;
import org.sqlite.parser.ast.ToSql;

public class CreateIndex
implements Stmt {
    public final boolean unique;
    public final boolean ifNotExists;
    public final QualifiedName idxName;
    public final String tblName;
    public final List<SortedColumn> columns;
    public final Expr whereClause;

    public CreateIndex(boolean unique, boolean ifNotExists, QualifiedName idxName, String tblName, List<SortedColumn> columns, Expr whereClause) {
        this.unique = unique;
        this.ifNotExists = ifNotExists;
        this.idxName = Objects.requireNonNull(idxName);
        this.tblName = Objects.requireNonNull(tblName);
        this.columns = ToSql.requireNotEmpty(columns);
        this.whereClause = whereClause;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        a.append("CREATE ");
        if (this.unique) {
            a.append("UNIQUE ");
        }
        a.append("INDEX ");
        if (this.ifNotExists) {
            a.append("IF NOT EXISTS ");
        }
        this.idxName.toSql(a);
        a.append(" ON ");
        ToSql.doubleQuote(a, this.tblName);
        a.append('(');
        ToSql.comma(a, this.columns);
        a.append(')');
        if (this.whereClause != null) {
            a.append(" WHERE ");
            this.whereClause.toSql(a);
        }
    }
}

