/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.Objects;
import org.sqlite.parser.ast.CreateTableBody;
import org.sqlite.parser.ast.QualifiedName;
import org.sqlite.parser.ast.Stmt;

public class CreateTable
implements Stmt {
    public final boolean temporary;
    public final boolean ifNotExists;
    public final QualifiedName tblName;
    public final CreateTableBody body;

    public CreateTable(boolean temporary, boolean ifNotExists, QualifiedName tblName, CreateTableBody body) {
        this.temporary = temporary;
        this.ifNotExists = ifNotExists;
        this.tblName = Objects.requireNonNull(tblName);
        this.body = Objects.requireNonNull(body);
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        a.append("CREATE ");
        if (this.temporary) {
            a.append("TEMP ");
        }
        a.append("TABLE ");
        if (this.ifNotExists) {
            a.append("IF NOT EXISTS ");
        }
        this.tblName.toSql(a);
        this.body.toSql(a);
    }
}

