/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.parser.ast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.sqlite.parser.ast.Expr;
import org.sqlite.parser.ast.QualifiedName;
import org.sqlite.parser.ast.Stmt;
import org.sqlite.parser.ast.TriggerCmd;
import org.sqlite.parser.ast.TriggerEvent;
import org.sqlite.parser.ast.TriggerTime;

public class CreateTrigger
implements Stmt {
    public final boolean temporary;
    public final boolean ifNotExists;
    public final QualifiedName triggerName;
    public final TriggerTime time;
    public final TriggerEvent event;
    public final QualifiedName tblName;
    public final boolean forEachRow;
    public final Expr whenClause;
    public final List<TriggerCmd> commands = new ArrayList<TriggerCmd>();

    public CreateTrigger(boolean temporary, boolean ifNotExists, QualifiedName triggerName, TriggerTime time, TriggerEvent event, QualifiedName tblName, boolean forEachRow, Expr whenClause) {
        this.temporary = temporary;
        this.ifNotExists = ifNotExists;
        this.triggerName = Objects.requireNonNull(triggerName);
        this.time = time;
        this.event = Objects.requireNonNull(event);
        this.tblName = Objects.requireNonNull(tblName);
        this.forEachRow = forEachRow;
        this.whenClause = whenClause;
    }

    @Override
    public void toSql(Appendable a) throws IOException {
        a.append("CREATE ");
        if (this.temporary) {
            a.append("TEMP ");
        }
        a.append("TRIGGER ");
        if (this.ifNotExists) {
            a.append("IF NOT EXISTS ");
        }
        this.triggerName.toSql(a);
        if (this.time != null) {
            a.append(' ');
            this.time.toSql(a);
        }
        a.append(' ');
        this.event.toSql(a);
        a.append(" ON ");
        this.tblName.toSql(a);
        if (this.forEachRow) {
            a.append(" FOR EACH ROW");
        }
        if (this.whenClause != null) {
            a.append(" WHEN ");
            this.whenClause.toSql(a);
        }
        a.append(" BEGIN\n");
        for (int i = 0; i < this.commands.size(); ++i) {
            if (i != 0) {
                a.append('\n');
            }
            this.commands.get(i).toSql(a);
            a.append(';');
        }
        a.append("END");
    }
}

